//---------------------------------------------------------------------------

#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <NMpop3.hpp>
#include <Psock.hpp>
#include <Menus.hpp>
#include "Trayicon.h"
#include "TDLPortIO.h"


//---------------------------------------------------------------------------

class TLCDInfo : public TForm
{
__published:	// IDE-managed Components
        TDLPortIO *DLPortIO1;
        TTimer *UpdateTimer1;
        TTimer *changescreen_Timer1;
        TTimer *POP3_Timer1;
        TNMPOP3 *NMPOP31;
        TPowersock *Powersock1;
        TTimer *SetiTimer1;
        TStatusBar *StatusBar1;
        TPopupMenu *PopupMenu1;
        TMenuItem *PopUpMenu1_Exit;
        TMenuItem *PopUpMenu1_Minimize;
        TTrayIcon *TrayIcon1;
        TMenuItem *PopUpMenu1_Show;
        TMainMenu *MainMenu1;
        TMenuItem *Exit1;
        TMenuItem *ReloadIni1;


        void __fastcall Lopeta_Button1Click(TObject *Sender);
        void __fastcall UpdateTimer1Timer(TObject *Sender);
        void __fastcall changescreen_Timer1Timer(TObject *Sender);
        void __fastcall POP3_Timer1Timer(TObject *Sender);
        void __fastcall SetiTimer1Timer(TObject *Sender);
        void __fastcall PaivitaIni_Button1Click(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall PopUpMenu1_ExitClick(TObject *Sender);
        void __fastcall PopUpMenu1_MinimizeClick(TObject *Sender);
        void __fastcall PopUpMenu1_ShowClick(TObject *Sender);
                
protected:

private:	// User declarations


public:		// User declarations

        //int BASE;
        //int wiring;
        //bool checkbusyflag;

        void TLCDInfo::ReadIni();
        DWORD TLCDInfo::GetWindowsVersion();
        std::string IniLineToLCDLine(std::string str2);
        std::string VarToValue(std::string var);
        
        bool TLCDInfo::ReadMBMData();
        int TLCDInfo::GetTemp(int index);
        int TLCDInfo::GetFan(int index);
        double TLCDInfo::GetVoltage(int index);
        int TLCDInfo::GetMhz();
        int TLCDInfo::GetUsage(int index);


        #if defined NT_VERSIO

        void TLCDInfo::ReadPDHSettings();
        void TLCDInfo::PDH_Error(LPTSTR error);
        void TLCDInfo::PDH_AddCounter(LPTSTR pszCounterName);
        void TLCDInfo::PDH_Init();
        void TLCDInfo::PDH_UnInit();
        void TLCDInfo::PDH_UpdateData();

        #endif

        void TLCDInfo::VLCDDraw();

        std::string TLCDInfo::PerfCounter(std::string var);
        std::string TLCDInfo::BatteryStatus(std::string var);
        std::string TLCDInfo::MBM(std::string var);
        std::string TLCDInfo::Uptime(std::string var);
        std::string TLCDInfo::MemStatus(std::string var);
        std::string TLCDInfo::Winamp(std::string var);
        std::string TLCDInfo::Seti(std::string var);
        std::string TLCDInfo::DiskFree(std::string var);
        std::string TLCDInfo::DiskSize(std::string var);
        std::string TLCDInfo::DriveType(std::string var);

        void __fastcall TLCDInfo::MinimizeToTray(TObject *Sender);

        __fastcall TLCDInfo(TComponent* Owner);
};

class cT6963C
{

private:
        //bool checkbusyflag;
        //bool wiring;
        //int BASE;
        int charactercount;
        int pixelcount;
        int G_BASE;
        int BYTES_PER_ROW;
        int font_width;

public:

        cT6963C::cT6963C();
        cT6963C::~cT6963C();

        void GetSettings(void);

        void StartLPTDriver(void);
        void WriteData(BYTE Data);
        void WriteCtrl(BYTE Command);
        void InitLCD(void);
        void WaitDisplayReady(void);
        void SetLCDXY(int x, int y);
        void SetLCDCursor(int x, int y);
        void ClearLCDText(void);
        void ClearLCDGraph(void);
        void PrintLCDText(char *string);
        void SetLCDPixel(int x, int y);
        void StartLCD(void);
        void QuitLCD(void);
        void ShowBMP(Graphics::TBitmap *pBitmap);
};

class cKS0108
{
#define SIZEBMP 1086
#define SIZELCD 1024

private:
        int DATA;
        int CONTROL;
        unsigned char CurrentColumn;
        BYTE count, arrayLCD[SIZELCD], arrayBmp[SIZEBMP];

public:

        cKS0108::cKS0108();
        cKS0108::~cKS0108();

        void GetSettings(void);

        void StartLCD(void);
        void QuitLCD(void);
        void StartLPTDriver(void);
        void Delay(void);
        void SendLCDCommand(unsigned char value, unsigned char CS);
        void SendLCDData(const unsigned char values[], unsigned int amount);
        void SetColumn(unsigned char y);
        void SetPage(unsigned char x);
        void SetStartLine(unsigned char line);
        void LCDprintf(unsigned char y, unsigned char page, char *Str);
        void ClearLCD();
        void InitLCD();
        void LCDprintf2(unsigned char y, unsigned char page, char *Str);
        void PutChr(unsigned char y, unsigned char page, char chr);
        void ConvertBMP(void);
        unsigned char getbits(unsigned x, int p, int n);
        void SetLCDXY(int x, int y);
        void SetLCDXY2(int x, int y);
        void PrintLCDText(char *string);
        void PrintLCDText2(char *string);
        void ShowBMP(AnsiString);

};

class cLCD
{

private:

public:

       cLCD::cLCD();
       cLCD::~cLCD();

       void GetSettings(void);

       void Start(void);
       void Quit(void);
       void Clear(void);
       void SetTextXY(int x, int y);
       void PrintText(char *string);
       void SetPixel(int x, int y);
       void ShowBMP(AnsiString filename);
       void ShowIcon(std::string icon);
       void DrawIcon(int xpos, int ypos, AnsiString filename);
       void cLCD::WinampIcon(int xpos, int ypos);
       void cLCD::UpdateIcons(void);

};

//---------------------------------------------------------------------------
extern PACKAGE TLCDInfo *LCDInfo;
//---------------------------------------------------------------------------
#endif

