//---------------------------------------------------------------------------

#include <vcl.h> 
#include <stdio.h>
#include <IniFiles.hpp>

#include <iostream>
#include <string>
#include <sstream>
#include <iomanip>
#include <fstream>
#include <vector>
#include <map>

#pragma hdrstop

#define TDLPORTIO

//#define NT_VERSIO

#if defined NT_VERSIO
#include <pdh.h>
#endif

#include "main.h"

//#include "t6963c.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Trayicon"
#pragma link "TDLPortIO"
#pragma resource "*.dfm"


enum BusType    {btISA,btSMBus,btVIA686ABus,btDirectIO};
enum SMBType    {smtSMBIntel,smtSMBAMD,smtSMBALi,smtSMBNForce,smtSMBSIS};
enum SensorType {stUnknown,stTemperature,stVoltage,stFan,stMhz,stPercentage};

struct SharedIndex{
      SensorType iType;               // type of sensor
      int        Count;               // number of sensor for that type
};

struct SharedSensor{
      SensorType  ssType;            // type of sensor
      char        ssName[12];        // name of sensor
      double      ssCurrent;         // current value
      double      ssLow;             // lowest readout
      double      ssHigh;            // highest readout
      long        ssCount;           // total number of readout
      long double ssTotal;           // total amout of all readouts
      double      ssAlarm1;          // temp & fan: low alarm; voltage: % off;
      double      ssAlarm2;          // temp: high alarm
};

struct SharedInfo{
      unsigned short  siSMB_Base;       // SMBus base address
      BusType         siSMB_Type;       // SMBus/Isa bus used to access chip
      SMBType         siSMB_Code;       // SMBus sub type, Intel, AMD or ALi
      byte            siSMB_Addr;       // Address of sensor chip on SMBus
      char            siSMB_Name[41];   // Nice name for SMBus
      unsigned short  siISA_Base;       // ISA base address of sensor chip on ISA
      int             siChipType;       // Chip nr, connects with Chipinfo.ini
      byte            siVoltageSubType; // Subvoltage option selected
};

struct SharedData{
      double       sdVersion;       // version number (example: 51090)
      SharedIndex  sdIndex[10];      // Sensor index
      SharedSensor sdSensor[100];    // sensor info
      SharedInfo   sdInfo;          // misc. info
      char         sdStart[41];     // start time
      char         sdCurrent[41];   // current time
      char         sdPath[256];     // MBM path
};

SharedSensor MBMSensor[100];

#if defined NT_VERSIO

HQUERY hQuery;

typedef struct _tag_PDHCounterStruct {
    DOUBLE multiplier;
    int precision;
    LONG lValue;	    // The current value of this counter
    HCOUNTER hCounter;      // Handle to the counter - given to use by PDH Library
} PDHCOUNTERSTRUCT, *PPDHCOUNTERSTRUCT;

std::vector<PDHCOUNTERSTRUCT*> Counters;
std::map<std::string, int> CounterMap;

#endif

//std::vector<int> GraphValues;
//int GraphMaxValue = 0;

int BASE;
int displaytype=3;

int wiring=0;
bool checkbusyflag=0;
int t6963csize=1;

int textcolumns=20;
int textrows=8;

int xpixels=128;
int ypixels=64;

const int maxtextrows=16;
const int maxscreens=10;
const int maxicons=10;

int currentscreen=0;
int previousscreen=0;

bool PDHEnable;
bool vlcdEnable=1;

AnsiString Pop3Host;
AnsiString Pop3UserID;
AnsiString Pop3Password;
bool Pop3Enable;
int mailcount=0;

AnsiString ScreenFile;

AnsiString Weekdays[7];

struct Seti{
        bool         Enable;
        int          Interval;
        AnsiString   StateDir;
        AnsiString   UserInfoDir;
        AnsiString   OutfileDir;
        double       Prog;
        std::string  User;
        int          nresults;
        double       totalcpu;
        int          spikes;
        int          gaussian;
        int          pulses;
        int          triplets;
}seti;

struct SkipScreen{
        bool  Enable;
        int   NoWinamp;
        int   Skip;
}skipscreen;

struct Screen{
        bool        Enable[maxscreens];
        int         Interval[maxscreens];
        AnsiString  Bitmap[maxscreens];
        AnsiString  Icon[maxscreens][maxicons];
        AnsiString  Lines[maxscreens][maxtextrows];
}screen;

std::string lcdbuffer[maxtextrows];
std::string lcdbufferold[maxtextrows];

Graphics::TBitmap *vlcdBitmap = new Graphics::TBitmap();

TLCDInfo *LCDInfo;
cT6963C T6963C;
cKS0108 KS0108;
cLCD LCD;
//---------------------------------------------------------------------------
__fastcall TLCDInfo::TLCDInfo(TComponent* Owner)
        : TForm(Owner)
{
  Application->OnMinimize = MinimizeToTray;

  ReadIni();

  LCDInfo->ClientHeight=ypixels*2+21;
  LCDInfo->ClientWidth=xpixels*2+1;

  #if defined NT_VERSIO

  if (PDHEnable)
  {
    PDH_Init();
    ReadPDHSettings();
  }

  #endif

  LCD.Start();

  // show first screen's bitmap
  if (screen.Bitmap[currentscreen] != "")
  {
    LCD.ShowBMP(screen.Bitmap[currentscreen]);
  }

  LCD.UpdateIcons();

}
//---------------------------------------------------------------------------

void TLCDInfo::ReadIni()
{
  // read setting from ini file
  TIniFile *ini;
  ini = new TIniFile(IncludeTrailingBackslash(
    ExtractFilePath(Application->ExeName))+"LCDINFO.INI");

  BASE  =  ini->ReadInteger( "Port", "Base", 0x378 );

  checkbusyflag = ini->ReadBool( "T6963C", "CheckBusyFlag", false);
  wiring  =  ini->ReadInteger( "T6963C", "Wiring", 0 );
  t6963csize = ini->ReadInteger( "T6963C", "Size", 1 );

  displaytype = ini->ReadInteger( "LCD", "Type", 3 );
  textcolumns = ini->ReadInteger( "LCD", "TextColumns", 20 );
  textrows = ini->ReadInteger( "LCD", "TextRows", 8 );
  xpixels = ini->ReadInteger( "LCD", "XPixels", 128 );
  ypixels = ini->ReadInteger( "LCD", "YPixels", 64 );

  UpdateTimer1->Interval = ini->ReadInteger( "Screens", "Update", 1000);

  PDHEnable = ini->ReadBool( "NTPerfMon", "Enable", false);

  //Pop3
  POP3_Timer1->Interval = ini->ReadInteger( "Pop3", "Update", 600000);
  Pop3Host = ini->ReadString( "Pop3", "Host", "");
  Pop3UserID = ini->ReadString( "Pop3", "UserID", "");
  Pop3Password = ini->ReadString( "Pop3", "Password", "");
  Pop3Enable = ini->ReadBool( "Pop3", "Enable", false);

  // Seti@Home
  seti.Enable = ini->ReadBool( "Seti@Home", "Enable", false);
  seti.Interval = ini->ReadInteger( "Seti@Home", "Interval", 60000);
  seti.StateDir = ini->ReadString( "Seti@Home", "Statedir", "");
  seti.UserInfoDir = ini->ReadString( "Seti@Home", "Userinfodir", "");
  seti.OutfileDir = ini->ReadString( "Seti@Home", "Outfiledir", "");

  // SkipScreen
  skipscreen.Enable = ini->ReadBool( "SkipScreen", "Enable", false);
  skipscreen.NoWinamp = ini->ReadInteger( "SkipScreen", "NoWinamp", -1);
  skipscreen.Skip=-1;

  // Weekdays
  for (int i=0;i<7;i++)
    Weekdays[i]=ini->ReadString( "Weekdays", i, "");


  // read screen settings from screenfile
  ScreenFile = ini->ReadString( "Screens", "ScreenFile", "screens\\default.ini");

  TIniFile *screenfile;
  screenfile = new TIniFile(IncludeTrailingBackslash(
    ExtractFilePath(Application->ExeName)) + ScreenFile);

  // Screen.Enable
  for (int i=0;i<maxscreens;i++)
    screen.Enable[i]=screenfile->ReadBool( "Screen"+IntToStr(i),"Enable", false);

  // Screen.Interval
  for (int i=0;i<maxscreens;i++)
    screen.Interval[i]=screenfile->ReadInteger( "Screen"+IntToStr(i),"Interval", 5000);

  // Screen.Bitmap
  for (int i=0;i<maxscreens;i++)
    screen.Bitmap[i]=screenfile->ReadString( "Screen"+IntToStr(i),"Bitmap", "");

  // Screen.Icon
  for (int i=0;i<maxscreens;i++)
    for (int j=0;j<maxicons;j++)
    {
      screen.Icon[i][j]=screenfile->ReadString( "Screen"+IntToStr(i),"Icon"+IntToStr(j), "");
    }

  // Screen.Lines
  for (int i=0;i<maxscreens;i++)
  {
    for (int j=0;j<maxtextrows;j++)
    {
      screen.Lines[i][j]=screenfile->ReadString( "Screen"+IntToStr(i),"Line"+IntToStr(j), "");
    }
  }

  delete ini;
  delete screenfile;
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Lopeta_Button1Click(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::FormClose(TObject *Sender, TCloseAction &Action)
{

  #if defined NT_VERSIO

  if (PDHEnable)
  {
    PDH_UnInit();
  }

  #endif

  // clear screen on exit
  LCD.Quit();

  delete vlcdBitmap;
}
//---------------------------------------------------------------------------


void __fastcall TLCDInfo::PaivitaIni_Button1Click(TObject *Sender)
{

  ReadIni();

  if (currentscreen != previousscreen)
    {
      LCD.Clear();
    }

  if (screen.Bitmap[currentscreen] != "")
  {
    LCD.ShowBMP(screen.Bitmap[currentscreen]);
  }

  LCD.UpdateIcons();

}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

void __fastcall TLCDInfo::PopUpMenu1_ExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::PopUpMenu1_MinimizeClick(TObject *Sender)
{
  MinimizeToTray(LCDInfo);
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::PopUpMenu1_ShowClick(TObject *Sender)
{
  Show();
  vlcdEnable=1;
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::MinimizeToTray(TObject *Sender)
{
  Hide();
  vlcdEnable=0;
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::UpdateTimer1Timer(TObject *Sender)
{
  if (vlcdEnable)
  {
    Graphics::TBitmap *pBitmap = new Graphics::TBitmap();

    vlcdBitmap->Width=xpixels;
    vlcdBitmap->Height=ypixels;
    vlcdBitmap->Canvas->Brush->Color=clYellow;
    //vlcdBitmap->Canvas->Pen->Color=clYellow;
    vlcdBitmap->Canvas->FillRect(Rect(0,0,xpixels,ypixels));
    vlcdBitmap->Canvas->Pen->Color=clBlack;

    if (screen.Bitmap[currentscreen] != "")
    {
      pBitmap->LoadFromFile(screen.Bitmap[currentscreen]);

      for(int i=0;i<xpixels;i++)
      {
        for(int j=0;j<ypixels;j++)
        {
          if(pBitmap->Canvas->Pixels[i][j]==0)
            vlcdBitmap->Canvas->Pixels[i][j]=clBlack;
        }
      }
    }

    delete pBitmap;
  }

  ReadMBMData();

  #if defined NT_VERSIO

  if (PDHEnable)
  {
    PDH_UpdateData();
  }

  #endif

  //LCDInfo->ClearLCDText();

  // refresh lines
  for (int i=0;i<textrows;i++)
  {
    lcdbuffer[i]=LCDInfo->IniLineToLCDLine(screen.Lines[currentscreen][i].c_str());
  }

  //VLCDDraw();

  /*
  // refresh programs screen
  Memo2->Clear();
  for (int i=0;i<8;i++)
  {
    Memo2->Lines->Add(lcdbuffer[i].c_str());
  }
  */

  for (int i=0;i<textrows;i++)
  {
    // check if new line is different compared to the old line
    if(lcdbuffer[i] != lcdbufferold[i])
    {
      // if it was different write it to the LCD
      if(lcdbuffer[i].length() > (unsigned int)textcolumns-1)
      {
        std::string line1 = lcdbuffer[i];
        std::string line2 = lcdbuffer[i];
        line1.erase(textcolumns-1, line1.length());
        line2.erase(0, textcolumns-1);
        LCD.SetTextXY(0,i);
        //AnsiString lcdline = lcdbuffer[i].c_str();
        LCD.PrintText((char*)line1.c_str());
        LCD.SetTextXY(1,i+1);
        LCD.PrintText((char*)line2.c_str());
      }
      else
      {
        LCD.SetTextXY(0,i);
        AnsiString lcdline = lcdbuffer[i].c_str();
        LCD.PrintText(lcdline.c_str());
      }
    }
  }

  // save lcd lines for the next check
  for (int i=0;i<textrows;i++)
  {
    lcdbufferold[i] = lcdbuffer[i];
  }


  LCD.UpdateIcons();

  if (vlcdEnable)
  {
    vlcdBitmap->Canvas->Brush->Style = bsClear;
    vlcdBitmap->Canvas->Font->Name="Terminal";
    //vlcdBitmap->Canvas->Font->Pitch=fpFixed;
    //vlcdBitmap->Canvas->Font->Height=-7;
    vlcdBitmap->Canvas->Font->Size=7;
    vlcdBitmap->Canvas->Font->Color = clBlack;

    for (int i=0;i<textrows;i++)
    {
      if(lcdbuffer[i].length() > (unsigned int)textcolumns-1)
      {
        std::string line1 = lcdbuffer[i];
        std::string line2 = lcdbuffer[i];
        line1.erase(textcolumns-1, line1.length());
        line2.erase(0, textcolumns-1);
        vlcdBitmap->Canvas->TextOut(0,i*8,line1.c_str());
        vlcdBitmap->Canvas->TextOut(7,i*8+8,line2.c_str());
      }
      else
      {
        vlcdBitmap->Canvas->TextOut(0,i*8,lcdbuffer[i].c_str());
      }

      //vlcdBitmap->Canvas->TextOut(0,i*8,lcdbuffer[i].c_str());
    }

    Canvas->StretchDraw(Rect(0,0, xpixels*2, ypixels*2), vlcdBitmap);
  }

}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::changescreen_Timer1Timer(TObject *Sender)
{
  // if you want to skip screen in some situation
  if (skipscreen.Enable)
  {
    // if winamp not found
    if (FindWindow("Winamp v1.x",NULL)==NULL)
      // set the screen to be skipped to value given in ini
      skipscreen.Skip=skipscreen.NoWinamp;
    // else set skipscreen to impossible value
    else skipscreen.Skip=-1;
  }

  // save current screen number
  previousscreen=currentscreen;

  // change to next screen
  do{
    if (currentscreen<maxscreens-1)
      currentscreen++;
    else currentscreen=0;
  // unless the screen is disable or a screen to be skipped
  }while (screen.Enable[currentscreen]==false || skipscreen.Skip == currentscreen);

  // timer to the value given in ini
  changescreen_Timer1->Interval=screen.Interval[currentscreen];

  // if screen changed clear LCD
  if (currentscreen != previousscreen)
  {
    LCD.Clear();
  }

  // if new screen has a bitmap, show it
  if (screen.Bitmap[currentscreen] != "")
  {
    LCD.ShowBMP(screen.Bitmap[currentscreen]);
  }

  // call screen refresh
  UpdateTimer1Timer(NULL);
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::POP3_Timer1Timer(TObject *Sender)
{
  if (Pop3Enable)
  {
    if (NMPOP31->Connected)
        NMPOP31->Disconnect();
     else
       {
        // check if you've got mail
        NMPOP31->Host = Pop3Host;
        NMPOP31->UserID = Pop3UserID;
        NMPOP31->Password = Pop3Password;
        NMPOP31->Connect();
        mailcount=NMPOP31->MailCount;
        NMPOP31->Disconnect();
      }
  }
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::SetiTimer1Timer(TObject *Sender)
{
// state.sah
if (seti.Enable)
   {
      std::string buffer;
      double prog=0;
      std::stringstream conv;
      std::ifstream statefile (seti.StateDir.c_str());
      // error checking disabled because when packet changes
      // state.sah disappears for a while
      //if (! statefile.is_open())
      //  { ShowMessage("Error opening state.sah"); }
      if (statefile.is_open())
      {
        while(strstr(buffer.c_str(),"prog=")==NULL)
        {
          std::getline(statefile, buffer);
        }
        buffer.erase(0,5);
        conv << buffer;
        conv >> prog;
      }
   seti.Prog = prog*100;
   }

// user_info.sah
if (seti.Enable)
   {
      std::string buffer;
      double totalcpu;
      std::stringstream conv;
      std::stringstream conv2;
      std::ifstream userinfofile (seti.UserInfoDir.c_str());
      if (! userinfofile.is_open())
        { ShowMessage("Error opening user_info.sah"); }
      if (userinfofile.is_open())
      {
        while(strstr(buffer.c_str(),"name=")==NULL)
        {
          std::getline(userinfofile, buffer);
        }
        buffer.erase(0,5);
        seti.User = buffer;

        //userinfofile.seekg(0);
        //buffer.clear();
        while(strstr(buffer.c_str(),"nresults=")==NULL)
        {
          std::getline(userinfofile, buffer);
        }
        buffer.erase(0,9);
        conv << buffer;
        conv >> seti.nresults;

        //userinfofile.seekg(0);
        //buffer.clear();
        while(strstr(buffer.c_str(),"total_cpu=")==NULL)
        {
          std::getline(userinfofile, buffer);
        }
        buffer.erase(0,10);

        conv2 << buffer;
        conv2 >> totalcpu;
        seti.totalcpu = totalcpu/3600/24/365;
      }
   }
// outfile.sah
if (seti.Enable)
   {
      std::string buffer;
      std::ifstream outfile (seti.OutfileDir.c_str());
      int spikes=0;
      int gaussian=0;
      int pulses=0;
      int triplets=0;

      if (! outfile.is_open())
        { ShowMessage("Error opening outfile.sah"); }
      if (outfile.is_open())
      {
        while(std::getline(outfile, buffer))
        {
          if (strstr(buffer.c_str(),"spike")!=NULL)
          spikes++;

          if (strstr(buffer.c_str(),"gaussian")!=NULL)
          gaussian++;

          if (strstr(buffer.c_str(),"pulse")!=NULL)
          pulses++;

          if (strstr(buffer.c_str(),"triplet")!=NULL)
          triplets++;

        }
        seti.spikes = spikes;
        seti.gaussian = gaussian;
        seti.pulses = pulses;
        seti.triplets = triplets;
      }
   }
}
//---------------------------------------------------------------------------
#if defined NT_VERSIO

std::string TLCDInfo::PerfCounter(std::string var)
{
  std::stringstream value;

  int i = CounterMap[var];
  value << std::setprecision(Counters[i]->precision) << Counters[i]->lValue*Counters[i]->multiplier;

  return value.str();
}

#endif
//---------------------------------------------------------------------------

std::string TLCDInfo::BatteryStatus(std::string var)
{
 //system battery status
 //Windows NT/2000/XP: Included in Windows 2000 and later.
 //Windows 95/98/Me: Included in Windows 95 and later.

 std::stringstream value;
 SYSTEM_POWER_STATUS SPS;
 GetSystemPowerStatus(&SPS);

 if (var=="bat_acline")
 {
   if (SPS.ACLineStatus==0)
     value << "Offline";
   else if(SPS.ACLineStatus==1)
     value << "Online";
   else
     value << "Unknown";
 }

 else if (var=="bat_charge")
 {
   if (SPS.BatteryFlag==1)
     value << "High";
   else if(SPS.BatteryFlag==2)
     value << "Low";
   else if(SPS.BatteryFlag==4)
     value << "Critical";
   else if(SPS.BatteryFlag==8)
     value << "Charging";
   else if(SPS.BatteryFlag==128)
     value << "No Battery";
   else
     value << "Unknown";
 }

 else if (var=="bat_lifepercent")
 {
     int per = SPS.BatteryLifePercent;
     value << per;
 }

 else if (var=="bat_lifetime")
 {
     int time = SPS.BatteryLifeTime;
     value << time;
 }

 else if (var=="bat_fulllifetime")
 {
     int time = SPS.BatteryFullLifeTime;
     value << time;
 }

  return value.str();
}
//---------------------------------------------------------------------------

std::string TLCDInfo::MBM(std::string var)
{
  std::stringstream value;

  if (var.find("mbmtemp", 0) == 0)
  {
    int kw_beg = var.find("(", 0) + 1;
    int kw_end = var.find(")", kw_beg);
    int kw_len = kw_end - kw_beg;

    if(kw_len < 0)
      return value.str();

    std::string param = var.substr(kw_beg, kw_len);

    value << GetTemp(atoi(param.c_str()));
  }

  else if (var.find("mbmvolt", 0) == 0)
  {
    int kw_beg = var.find("(", 0) + 1;
    int kw_end = var.find(")", kw_beg);
    int kw_len = kw_end - kw_beg;

    if(kw_len < 0)
      return value.str();

    std::string param = var.substr(kw_beg, kw_len);

    value << std::setw(4) << std::setprecision(3) << GetVoltage(atoi(param.c_str()));
  }

  else if (var.find("mbmfan", 0) == 0)
  {
    int kw_beg = var.find("(", 0) + 1;
    int kw_end = var.find(")", kw_beg);
    int kw_len = kw_end - kw_beg;

    if(kw_len < 0)
      return value.str();

    std::string param = var.substr(kw_beg, kw_len);

    value << GetFan(atoi(param.c_str()));
  }

  else if (var.find("mbmmhz", 0) == 0)
  {
    value << GetMhz();
  }

  else if (var.find("mbmusage", 0) == 0)
  {
    int kw_beg = var.find("(", 0) + 1;
    int kw_end = var.find(")", kw_beg);
    int kw_len = kw_end - kw_beg;

    if(kw_len < 0)
      return value.str();

    std::string param = var.substr(kw_beg, kw_len);

    value << GetUsage(atoi(param.c_str()));
  }

  return value.str();
}
//---------------------------------------------------------------------------
std::string TLCDInfo::Uptime(std::string var)
{
  std::stringstream value;

  long secs,s,d,h,h2,m,rs;
  secs = GetTickCount();
  s = secs/1000;
  h = s / 3600;
  m = (s - (h * 3600))/60;
  rs= (s - ((m * 60) + (h * 3600)));
  d = (s / 3600) / 24;
  h2 = s / 3600 -(d*24);

  if (var=="uptimed")
    value << std::setw(2) << d;
  else if (var=="uptimeh")
    value << std::setw(2) << h2;
  else if (var=="uptimem")
    value << std::setw(2) << m;
  else if (var=="uptimes")
    value << std::setw(2) << rs;

  return value.str();
}
//---------------------------------------------------------------------------
std::string TLCDInfo::MemStatus(std::string var)
{
  std::stringstream value;

  MEMORYSTATUS MemStatus;
  MemStatus.dwLength = sizeof(MemStatus);
  GlobalMemoryStatus(&MemStatus);

  if (var=="memtotphys")
    value << MemStatus.dwTotalPhys/1024;
  else if (var=="memavphys")
    value << MemStatus.dwAvailPhys/1024;
  else if (var=="memusage")
    value << MemStatus.dwMemoryLoad;
  else if (var=="memtotpage")
    value << MemStatus.dwTotalPageFile/1024;
  else if (var=="memavpage")
    value << MemStatus.dwAvailPageFile/1024;
  else if (var=="memtotvirt")
    value << MemStatus.dwTotalVirtual/1024;
  else if (var=="memavvirt")
    value << MemStatus.dwAvailVirtual/1024;

  return value.str();
}
//---------------------------------------------------------------------------
std::string TLCDInfo::Winamp(std::string var)
{
 std::stringstream value;

 HWND hwndWinamp = FindWindow("Winamp v1.x",NULL);

 if (var=="winampstatus")
   {
     int status = SendMessage(hwndWinamp,WM_USER, 0, 104);

     if (status==1)
     {
       //ShowIcon(6,14,"play.bmp");
       value << "playing";
     }
     else if (status==3)
     {
        //ShowIcon(6,14,"pause.bmp");
        value << "paused";
     }
     else
     {
        //ShowIcon(6,14,"stop.bmp");
        value << "stopped";
     }
   }
 else if (var=="winamptrackpos")
   {
   int pos=SendMessage(hwndWinamp,WM_USER, 0, 105);
   value << pos/1000/60 << ":" << std::setfill('0') << std::setw(2) << pos/1000%60;
   }
 else if (var=="winamptracklen")
   {
   int pos=SendMessage(hwndWinamp,WM_USER, 1, 105);
   value << pos/60 << ":" << std::setfill('0') << std::setw(2) << pos%60;
   }
 //sprintf(string,"%d:%.2d / %d:%.2d",ret2/1000/60, ret2/1000%60, ret3/60, ret3%60);
 else if (var=="winamptitle")
   {
   char this_title[2048],*p;
   GetWindowText(hwndWinamp,this_title,sizeof(this_title));
   p = this_title+strlen(this_title)-8;
   while (p >= this_title)
   {
     if (!strnicmp(p,"- Winamp",8)) break;
     p--;
   }
   if (p >= this_title) p--;
   while (p >= this_title && *p == ' ') p--;
   *++p=0;

   value << this_title;
   }
 else if (var=="winampsamplerate")
   {
   int rate=SendMessage(hwndWinamp,WM_USER, 0, 126);
   value << rate;
   }
 else if (var=="winampbitrate")
   {
   int rate=SendMessage(hwndWinamp,WM_USER, 1, 126);
   value << std::setw(3) << rate;
   }
 else if (var=="winampchannels")
   {
   int channels=SendMessage(hwndWinamp,WM_USER, 2, 126);
   if (channels==2)
     value << std::setw(6) << "Stereo";
    else if (channels==1)
     value << std::setw(6) << "Mono";
    else
     value << std::setw(6) << "?";
   }

  return value.str();
}
//---------------------------------------------------------------------------
std::string TLCDInfo::Seti(std::string var)
{
 std::stringstream value;

 if (var=="setiprog")
 {
   value << std::setiosflags(std::ios::left) << std::setw(4) <<
         std::setprecision(3) << seti.Prog;
 }

 else if (var=="setiuser")
 {
   value << seti.User;
 }

 else if (var=="setinresults")
 {
   value << std::setiosflags(std::ios::left) << std::setw(6) << seti.nresults;
 }

 else if (var=="setitotal_cpu")
 {
   if (seti.totalcpu<10)
     value << std::setiosflags(std::ios::fixed) <<
     std::setiosflags(std::ios::left) << std::setprecision(3) <<
     std::setw(5) << seti.totalcpu;
   else
     value << std::setiosflags(std::ios::left) << std::setprecision(4) <<
     std::setw(5) << seti.totalcpu;
 }

 else if (var=="setispike")
 {
   value << std::setw(2) << seti.spikes;
 }

 else if (var=="setigaussian")
 {
   value << std::setw(2) << seti.gaussian;
 }

 else if (var=="setipulse")
 {
   value << std::setw(2) << seti.pulses;
 }

 else if (var=="setitriplet")
 {
   value << std::setw(2) << seti.triplets;
 }

  return value.str();
}
//---------------------------------------------------------------------------

DWORD TLCDInfo::GetWindowsVersion()
{
  OSVERSIONINFO OSversion;
  OSversion.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);

  GetVersionEx(&OSversion);
  return OSversion.dwPlatformId;
}
//---------------------------------------------------------------------------
std::string TLCDInfo::DiskFree(std::string var)
{
  std::stringstream value;

  ULARGE_INTEGER FreeBytesAvailableToCaller, TotalNumberOfBytes, TotalNumberOfFreeBytes;

  int kw_beg = var.find("(", 0) + 1;
  int kw_end = var.find(")", kw_beg);
  int kw_len = kw_end - kw_beg;

  if(kw_len < 0)
    return value.str();

  std::string param = var.substr(kw_beg, kw_len);

  ::GetDiskFreeSpaceEx(param.c_str(), &FreeBytesAvailableToCaller, &TotalNumberOfBytes, &TotalNumberOfFreeBytes );

  value << TotalNumberOfFreeBytes.QuadPart/1024/1024;
  return value.str();
}
//---------------------------------------------------------------------------

std::string TLCDInfo::DiskSize(std::string var)
{
  std::stringstream value;

  ULARGE_INTEGER FreeBytesAvailableToCaller, TotalNumberOfBytes, TotalNumberOfFreeBytes;

  int kw_beg = var.find("(", 0) + 1;
  int kw_end = var.find(")", kw_beg);
  int kw_len = kw_end - kw_beg;

  if(kw_len < 0)
    return value.str();

  std::string param = var.substr(kw_beg, kw_len);

  ::GetDiskFreeSpaceEx(param.c_str(), &FreeBytesAvailableToCaller, &TotalNumberOfBytes, &TotalNumberOfFreeBytes );

  value << TotalNumberOfBytes.QuadPart/1024/1024;

  return value.str();
}
//---------------------------------------------------------------------------

std::string TLCDInfo::DriveType(std::string var)
{
  std::stringstream value;

  int kw_beg = var.find("(", 0) + 1;
  int kw_end = var.find(")", kw_beg);
  int kw_len = kw_end - kw_beg;

  if(kw_len < 0)
    return value.str();

  std::string param = var.substr(kw_beg, kw_len);

  switch (GetDriveType(param.c_str()))
      {
      case DRIVE_REMOVABLE:	value << "Removable";   break;
      case DRIVE_FIXED:		value << "Fixed";    	break;
      case DRIVE_REMOTE:	value << "Remote";   	break;
      case DRIVE_CDROM:		value << "CDROM";    	break;
      case DRIVE_RAMDISK:	value << "RamDisk";  	break;
      default:			value << "Unknown";     break;
      }

  return value.str();
}
//---------------------------------------------------------------------------

std::string TLCDInfo::VarToValue(std::string var)
{
 std::stringstream value;

 //MBM
 if (var.find("mbm", 0) == 0)
 {
   value << MBM(var);
 }

 #if defined NT_VERSIO

 //NT Performance Counters
 else if (var.find("pdh_", 0) == 0)
 {
   value << PerfCounter(var);
 }

 #endif

 //System battery
 else if (var.find("bat_", 0) == 0)
 {
   value << BatteryStatus(var);
 }

 //Uptime
 else if (var.find("uptime", 0) == 0)
 {
   value << Uptime(var);
 }

 //memstatus
 else if (var.find("mem", 0) == 0)
 {
   value << MemStatus(var);
 }

 //winamp
 else if (var.find("winamp", 0) == 0)
 {
   value << Winamp(var);
 }

 // computername
 else if (var=="computername")
 {
   char compuname[50];
   unsigned long nSize=sizeof(compuname);

   GetComputerName(compuname,&nSize);
   value << compuname;
 }

 // pop3 mail
 else if (var=="mailcount")
   value << mailcount;

 //date / time
 else if (var=="weekday")
 {
 TDateTime dtDate = Now();
 value << std::setiosflags(std::ios::left) << std::setw(11) << (Weekdays[dtDate.DayOfWeek()-1].c_str());
 }
 else if (var=="date")
 {
 value << std::setiosflags(std::ios::left) << std::setw(10)<< (DateToStr(Now()).c_str());
 }
 else if (var=="time")
 {
 value << std::setiosflags(std::ios::left) << std::setw(8) << (TimeToStr(Now()).c_str());
 }

 //ip
 else if (var=="omaip")
 {
 value << std::setiosflags(std::ios::left) << Powersock1->LocalIP.c_str();
 }

 // windowsversion
 else if (var=="winver")
 {
   if (GetWindowsVersion()==VER_PLATFORM_WIN32_WINDOWS)
     value << "win9x";
   else if (GetWindowsVersion()==VER_PLATFORM_WIN32_NT)
     value << "winnt";
 }

 //diskfree
 else if (var.find("diskfree", 0) == 0)
 {
   value << DiskFree(var);
 }

 //disksize
 else if (var.find("disksize", 0) == 0)
 {
   value << DiskSize(var);
 }

 //drivetype
 else if (var.find("drivetype", 0) == 0)
 {
   value << DriveType(var);
 }

 // if no equivalence was found return empty string
 else
   value << "";

return value.str();
}
//---------------------------------------------------------------------------

std::string TLCDInfo::IniLineToLCDLine(std::string str2)
{
  std::string str = str2;

  int len = str.length();

  for(int i = 0; i < len; i++)
  {
        if(str[i] == '$')
        {
              int kw_beg = i + 1;
              int kw_end = str.find("$", kw_beg);
              int kw_len = kw_end - kw_beg;

              if(kw_len < 0)
                      continue;

              std::string keyword = str.substr(kw_beg, kw_len);
              std::stringstream stor;

              stor.clear();

              /*if(keyword == "mhzmuuttuja")
                      stor << 1400;
              else if(keyword == "mbmtemp")
                      stor << 53;
              else if(keyword == "lehma")
                      stor << "Mansikki";
              */
              stor << VarToValue(keyword);

              str.replace(kw_beg - 1, kw_len + 2, stor.str());

              i += stor.str().length() - 1;
              len = str.length();
        }
  }
  return str;
}
//---------------------------------------------------------------

//PDH functions

#if defined NT_VERSIO

void TLCDInfo::ReadPDHSettings()
{
  TIniFile* perfIni = new TIniFile(IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+"LCDPERF.INI");
  TStringList *sectionsList = new TStringList;

  try
  {
    perfIni->ReadSections(sectionsList);

    for (int i = 0; i < sectionsList->Count; i++)
    {
      TListItem  *ListItem;

      CounterMap[sectionsList->Strings[i].c_str()]=i;
      AnsiString CounterPath = perfIni->ReadString(sectionsList->Strings[i], "name", "");
      PDH_AddCounter(CounterPath.c_str());
      Counters[i]->multiplier = perfIni->ReadFloat(sectionsList->Strings[i], "multiplier", 1);
      Counters[i]->precision = perfIni->ReadInteger(sectionsList->Strings[i], "precision", 4);
    }
  }
  __finally
  {
    delete sectionsList;
  }
  
  delete perfIni;
  //UpdatePerformanceCountersListValues();
}

void TLCDInfo::PDH_Error(LPTSTR error)
{
  StatusBar1->SimpleText=StatusBar1->SimpleText + error;
}

void TLCDInfo::PDH_AddCounter(LPTSTR pszCounterName)
{
  PPDHCOUNTERSTRUCT pCounter;
  pCounter = new PDHCOUNTERSTRUCT;

  if (PdhAddCounter(hQuery, pszCounterName, (DWORD)pCounter, &(pCounter->hCounter)) != ERROR_SUCCESS)
  {
          delete pCounter; // clean mem
          PDH_Error("PdhAddCounter error");
          return;
  }

  Counters.insert(Counters.end(), pCounter);
}

void TLCDInfo::PDH_Init()
{
  if (PdhOpenQuery(NULL, 1, &hQuery) != ERROR_SUCCESS)
    PDH_Error("PdhOpenQuery error");
}

void TLCDInfo::PDH_UnInit()
{
  PdhCloseQuery(&hQuery);
}

void TLCDInfo::PDH_UpdateData()
{
  if (PdhCollectQueryData(hQuery) != ERROR_SUCCESS)
    PDH_Error("PdhCollectQueryData error");

  for(unsigned int i = 0; i < Counters.size(); i++)
  {
    PDH_FMT_COUNTERVALUE pdhFormattedValue;

    if (PdhGetFormattedCounterValue(Counters[i]->hCounter, PDH_FMT_LONG, NULL, &pdhFormattedValue) != ERROR_SUCCESS)
    {
      PDH_Error("PdhGetFormattedCounterValue error");
    }
    if (pdhFormattedValue.CStatus != ERROR_SUCCESS)
    {
      PDH_Error("pdhFormattedValue.CStatus error");
    }

    Counters[i]->lValue = pdhFormattedValue.longValue;
  }
}

#endif

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

//MBM functions
bool TLCDInfo::ReadMBMData()
{
  SharedData *ptr;
  HANDLE hSData;

  hSData=OpenFileMapping(FILE_MAP_READ, False, "$M$B$M$5$S$D$");
  if (hSData==0) return false;

  ptr = (SharedData *)MapViewOfFile(hSData, FILE_MAP_READ, 0, 0, 0);
  if (ptr == 0){
      CloseHandle(hSData);
      return false;
  }
  int sensorcount = 0;

  for(int i=0; i < 9; i++)
  {
    sensorcount += ptr->sdIndex[i].Count;
  }

  for (int i=0; i < sensorcount; i++)
  {
    MBMSensor[i].ssCurrent = ptr->sdSensor[i].ssCurrent;
  }


  UnmapViewOfFile(ptr);
  CloseHandle(hSData);

  return true;
}

int TLCDInfo::GetTemp(int index)
{
  return MBMSensor[index].ssCurrent;
}

int TLCDInfo::GetFan(int index)
{
  return MBMSensor[48 + index].ssCurrent;
}

double TLCDInfo::GetVoltage(int index)
{
  return MBMSensor[32 + index].ssCurrent;
}

int TLCDInfo::GetMhz()
{
  return MBMSensor[64].ssCurrent;
}

int TLCDInfo::GetUsage(int index)
{
  return MBMSensor[65 + index].ssCurrent;
}

/* LCD FUNCTIONS ***********************************************/
/***************************************************************/


//---------------------------------------------------------------------------

void TLCDInfo::VLCDDraw()
{
  Graphics::TBitmap *vlcdBitmap = new Graphics::TBitmap();
  Graphics::TBitmap *pBitmap = new Graphics::TBitmap();

  vlcdBitmap->Width=xpixels;
  vlcdBitmap->Height=ypixels;
  vlcdBitmap->Canvas->Brush->Color=clYellow;
  //vlcdBitmap->Canvas->Pen->Color=clYellow;
  vlcdBitmap->Canvas->FillRect(Rect(0,0,xpixels,ypixels));
  vlcdBitmap->Canvas->Pen->Color=clBlack;

  if (screen.Bitmap[currentscreen] != "")
  {
    pBitmap->LoadFromFile(screen.Bitmap[currentscreen]);

    for(int i=0;i<xpixels;i++)
    {
      for(int j=0;j<ypixels;j++)
      {
        if(pBitmap->Canvas->Pixels[i][j]==0)
          vlcdBitmap->Canvas->Pixels[i][j]=clBlack;
      }
    }
  }

  vlcdBitmap->Canvas->Brush->Style = bsClear;
  vlcdBitmap->Canvas->Font->Name="Terminal";
  //vlcdBitmap->Canvas->Font->Pitch=fpFixed;
  //vlcdBitmap->Canvas->Font->Height=-7;
  vlcdBitmap->Canvas->Font->Size=7;
  vlcdBitmap->Canvas->Font->Color = clBlack;

  for (int i=0;i<textrows;i++)
  {
    vlcdBitmap->Canvas->TextOut(0,i*8,lcdbuffer[i].c_str());
  }

  // if current screen has icon call icon function
  for (int i=0; i<5; i++)
  {
    if (screen.Icon[currentscreen][i] != "")
    {
      LCD.ShowIcon(screen.Icon[currentscreen][i].c_str());
    }
  }

  Canvas->StretchDraw(Rect(15,20, 15+xpixels*2, 20+ypixels*2), vlcdBitmap);

  delete pBitmap;
  delete vlcdBitmap;

}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// { class T6963C

//#define G_BASE 0x0200   // grafiikkamuistin base address 240*64
//#define G_BASE 0x0300   // grafiikkamuistin base address 240*128 ?
#define T_BASE 0x0000   // tekstimuistin base address
//#define BYTES_PER_ROW 40 // merkki rivill

cT6963C::cT6963C()
{
}

cT6963C::~cT6963C()
{
}

void cT6963C::GetSettings(void)
{
  /*
  checkbusyflag=LCDInfo->checkbusyflag;
  wiring=LCDInfo->wiring;
  BASE=LCDInfo->BASE;
  */
  if(t6963csize==1) //240x64 6x8 font
  {
    charactercount = 320;
    pixelcount = 2560;
    G_BASE = 0x0200;   // grafiikkamuistin base address 240*64
    BYTES_PER_ROW = 40;
    font_width=6;
  }
  else if (t6963csize==2) //240x128 6x8 font
  {
    charactercount = 640;
    pixelcount = 5120;
    G_BASE = 0x0300;   // grafiikkamuistin base address 240*128 ?
    BYTES_PER_ROW = 40;
    font_width=6;
  }
  else if (t6963csize==3) //256x40 8x8 font
  {
    charactercount = 160;
    pixelcount = 1280;
    G_BASE = 0x0200;   // grafiikkamuistin base address
    BYTES_PER_ROW = 32;
    font_width=8;
  }
  else if (t6963csize==4) //128x128 8x8 font
  {
    charactercount = 256;
    pixelcount = 2048;
    G_BASE = 0x0300;   // grafiikkamuistin base address
    BYTES_PER_ROW = 16;
    font_width=8;
  }
  else if (t6963csize==5) //128x128 6x8 font
  {
    charactercount = 336;
    pixelcount = 2731;
    G_BASE = 0x0300;   // grafiikkamuistin base address
    BYTES_PER_ROW = 21;
    font_width=6;
  }
  else if (t6963csize==6) //160x128 8x8 font
  {
    charactercount = 320;
    pixelcount = 2560;
    G_BASE = 0x0300;   // grafiikkamuistin base address
    BYTES_PER_ROW = 20;
    font_width=8;
  }
}

void cT6963C::StartLCD(void)
{
  GetSettings();
  StartLPTDriver();
  InitLCD();
  ClearLCDText();
  ClearLCDGraph();
}

void cT6963C::QuitLCD(void)
{
  ClearLCDText();
  ClearLCDGraph();
}

void cT6963C::StartLPTDriver(void)
{
   #if defined TDLPORTIO
        //ajurin hakemisto
        LCDInfo->DLPortIO1->DriverPath=ExtractFileDir(ParamStr(0));
        // ajurin avaus
        LCDInfo->DLPortIO1->OpenDriver();
        if (!LCDInfo->DLPortIO1->ActiveHW)
   {
      MessageDlg("Could not open the DriverLINX driver.",
                 mtError, TMsgDlgButtons() << mbOK, 0);
   }
   #endif
}

void cT6963C::WaitDisplayReady(void)
// reads the display status byte and checks
// that the display is ready before writing

// doesn't have any check in case the status byte
// can't be read so this situation may cause a lockup
// some check for this needs to be done

{
  #if defined TDLPORTIO
  int Tmp;

       Tmp = LCDInfo->DLPortIO1->Port[BASE + 0x402];
       Tmp = Tmp & 0x1F;
       Tmp = Tmp | 0x20;
       LCDInfo->DLPortIO1->Port[BASE + 0x402] = Tmp;

       do{
             LCDInfo->DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2;     //In, CD=1, CS=0, Wr=1
             LCDInfo->DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2 + 8; //In, CD=1, CS=0, Wr=1, Rd=0
             Tmp = LCDInfo->DLPortIO1->Port[BASE];
             LCDInfo->DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2;     //In, CD=1, CS=0, Wr=1

       }while ((Tmp & 3) != 3 );
       LCDInfo->DLPortIO1->Port[BASE + 2] = 0;
    #endif
}

void cT6963C::WriteData(BYTE Data)
{
  if (checkbusyflag)
  {
    WaitDisplayReady();
  }

  if (wiring==0)
  {
    #if defined TDLPORTIO
    LCDInfo->DLPortIO1->Port[BASE] = Data;
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0; // C/D = L (Data)
    LCDInfo->DLPortIO1->Port[BASE + 2] = 2; // CE
    LCDInfo->DLPortIO1->Port[BASE + 2] = 3; // CE+WR
    LCDInfo->DLPortIO1->Port[BASE + 2] = 2; // CE
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0;
    #endif

    #if defined DLPORT
    DlPortWritePortUshort(BASE + 2, 0);	// 0111 C/D low
    DlPortWritePortUshort(BASE + 2, 2);	// 0011 WR low
    DlPortWritePortUshort(BASE, Data);
    DlPortWritePortUshort(BASE + 2, 3);	// 0010 CE low
    DlPortWritePortUshort(BASE + 2, 2);	// 0011 CE high
    DlPortWritePortUshort(BASE + 2, 0);	// 0111 WR high
    #endif
  }
  else
  {
    #if defined TDLPORTIO
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x0c;	// 0111 C/D low
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x08;	// 0011 WR low
    LCDInfo->DLPortIO1->Port[BASE] = Data;
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x09;	// 0010 CE low
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x08;	// 0011 CE high
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x0c;	// 0111 WR high
    #endif
  }
}

void cT6963C::WriteCtrl(BYTE Command)
{
  if (checkbusyflag)
  {
    WaitDisplayReady();
  }
  
  if (wiring==0)
  {
    #if defined TDLPORTIO
    LCDInfo->DLPortIO1->Port[BASE] = Command;
    LCDInfo->DLPortIO1->Port[BASE + 2] = 4;   // C/D = H (ctrl)
    LCDInfo->DLPortIO1->Port[BASE + 2] = 4+2; // CE
    LCDInfo->DLPortIO1->Port[BASE + 2] = 4+3; // CE+WR
    LCDInfo->DLPortIO1->Port[BASE + 2] = 4+2; // CE
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0;
    #endif

    #if defined DLPORT
    DlPortWritePortUshort(BASE, Command);
    DlPortWritePortUshort(BASE + 2, 4);		// 1111 C/D high
    DlPortWritePortUshort(BASE + 2, 4+2);		// 1011 WR low
    DlPortWritePortUshort(BASE + 2, 4+3);		// 1010 CE low
    DlPortWritePortUshort(BASE + 2, 4+2);		// 1011 CE high
    DlPortWritePortUshort(BASE + 2, 0);		// 0111 C/D low
    #endif
  }
  else
  {
    #if defined TDLPORTIO
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x04;		// 1111 C/D high
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x00;		// 1011 WR low
    LCDInfo->DLPortIO1->Port[BASE] = Command;
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x01;		// 1010 CE low
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x00;		// 1011 CE high
    LCDInfo->DLPortIO1->Port[BASE + 2] = 0x0c;		// 0111 C/D low
    #endif
  }
}

void cT6963C::InitLCD(void)
{
  // Display init
  WriteData(T_BASE & 0xFF);   //Data1: LowAddress
  WriteData(T_BASE >> 8);     //Data2: HighAddress
  WriteCtrl(0x40);            //Command: 0x40 -> 01000000

  WriteData(BYTES_PER_ROW);  //Data1: Colums
  WriteData(0);              //Data2: 0
  WriteCtrl(0x41);           //Command: 0x41 -> 01000001

  WriteData(G_BASE & 0xFF);  //Data1: LowAddress
  WriteData(G_BASE >> 8);    //Data2: HighAddress
  WriteCtrl(0x42);           //Command: 0x42 -> 01000010

  WriteData(BYTES_PER_ROW);  //Data1: Colums
  WriteData(0);              //Data2: 0
  WriteCtrl(0x43);           //Command: 0x43 -> 01000011

  //Internal CGROM Mode, OR Mode
  WriteCtrl(0x80); // OR Mode    //80->10000000

  WriteCtrl(0xa7); // cursor is 8 lines high
  WriteData(0x00);
  WriteData(0x00);
  WriteCtrl(0x21); // put cursor at (x,y)

  //DisplayMode
  WriteCtrl(0x9D);

  // CG RAM
  // WriteData(2);
  // WriteData(0);
  // WriteCtrl(0x22);

}

void cT6963C::SetLCDXY(int x, int y)
{
int addr;
  addr = T_BASE + (y * BYTES_PER_ROW) + x;
  WriteData(addr & 0xFF);
  WriteData(addr >> 8);
  WriteCtrl(0x24);
}

void cT6963C::SetLCDCursor(int x, int y)
{
  WriteData(x);
  WriteData(y);
  WriteCtrl(0x21);
}

void cT6963C::ClearLCDText(void)
{
  int i;

  WriteData(T_BASE & 0xFF);
  WriteData(T_BASE >> 8);
  WriteCtrl(0x24);      // address pointer to T_BASE

  for (i=0;i<charactercount;i++) {
        WriteData(0); WriteCtrl(0xc0); // write data and inc ptr
  }
}

void cT6963C::ClearLCDGraph(void)
{
  int i;

  WriteData(G_BASE & 0xFF);
  WriteData(G_BASE >> 8);
  WriteCtrl(0x24); // address pointer to G_BASE

  for (i=0;i<pixelcount;i++){
        WriteData(0); WriteCtrl(0xc0); // write data and inc ptr
  }
}

void cT6963C::PrintLCDText(char *string)
{
  unsigned int i;
  char c;

  for (i=0;i<strlen(string);i++){
        c = string[i] - 0x20; // conversion from ASCII to LCD characters
        if (c<0) c=0;
        WriteData(c);
        WriteCtrl(0xc0);
  }
}

void cT6963C::SetLCDPixel(int x, int y)
{
  int addr;

  addr = G_BASE + (y*BYTES_PER_ROW) + (x/font_width);
  WriteData(addr & 0xFF);
  WriteData(addr >> 8);
  WriteCtrl(0x24);
  WriteCtrl(0xf8 | (5-(x % font_width)));
}

void cT6963C::ShowBMP(Graphics::TBitmap *pBitmap)
{
  int x=0,y=0,z;
  int i;
  int addr;
  float pp;
  TColor p;

  Randomize();

     //bitmap to the program window
    //Canvas->Draw(15,350,pBitmap);


    /*for(y=0;y<64;y++)
      for(x=0;x<240;x++)
        {
        if (pBitmap->Canvas->Pixels[x][y]==0)
          Form1->SetLCDPixel(x,y);
        }*/

  addr = G_BASE + (y*BYTES_PER_ROW) + (x/font_width);
  //WriteCtrl(0xf8 | (5-(x % 6)));   // ???

  T6963C.WriteData(addr & 0xFF);
  T6963C.WriteData(addr >> 8);
  T6963C.WriteCtrl(0x24);
  for (y=0;y<ypixels;y++)
    for (x=0;x<xpixels/font_width;x++)
    {
      i=0;
      for(z=0;z<font_width;z++)
      {
        p=pBitmap->Canvas->Pixels[x*font_width+z][y];
        pp=0.6*(p & 0xFF)+0.30*((p >> 8) & 0xFF)+0.1*((p >> 16) & 0xFF);
        i=i << 1;
        if (pp<=random(255))
           i=i | 1;
      }
      T6963C.WriteData(i);
      T6963C.WriteCtrl(0xC0);
    }
}

// } class T6963C
//---------------------------------------------------------------------------

// { class LCD

cLCD::cLCD()
{

}

cLCD::~cLCD()
{

}

void cLCD::GetSettings(void)
{

}

void cLCD::Start(void)
{
  if(displaytype==0)
    T6963C.StartLCD();
  else if(displaytype==1)
    KS0108.StartLCD();
  else
  {}

}

void cLCD::Quit(void)
{
  if(displaytype==0)
    T6963C.QuitLCD();
  else if(displaytype==1)
    KS0108.QuitLCD();
  else
  {}
}

void cLCD::Clear(void)
{
  if(displaytype==0)
    {
      T6963C.ClearLCDGraph();
      T6963C.ClearLCDText();
    }
  else if(displaytype==1)
    KS0108.ClearLCD();
  else
  {}
}

void cLCD::SetTextXY(int x, int y)
{
  if(displaytype==0)
    {
      T6963C.SetLCDXY(x,y);
    }
  else if(displaytype==1)
    KS0108.SetLCDXY2(x,y);
  else
  {}
}

void cLCD::PrintText(char *string)
{
  if(displaytype==0)
    {
      T6963C.PrintLCDText(string);
    }
  else if(displaytype==1)
    KS0108.PrintLCDText2(string);
  else
  {}
}

void cLCD::SetPixel(int x, int y)
{
  if(displaytype==0)
    {
      T6963C.SetLCDPixel(x,y);
    }
  else if(displaytype==1)
    {
    }
  else
  {}
}

void cLCD::ShowBMP(AnsiString filename)
{

  if(displaytype==0)
    {
    Graphics::TBitmap *pBitmap = new Graphics::TBitmap();
    try
    {
      pBitmap->LoadFromFile(filename);

      T6963C.ShowBMP(pBitmap);

    }

    catch (...)

    {
      ShowMessage("Could not load or display bitmap");
    }
    delete pBitmap;
  }
  else if(displaytype==1)
  {
   KS0108.ShowBMP(filename);
  }
  else
  {}

}

//---------------------------------------------------------------------------

void cLCD::ShowIcon(std::string icon)
{
  if (icon.find("winamp", 0) == 0)
  {
    int par_beg = icon.find("(", 0) + 1;
    int comma = icon.find(",", par_beg);
    int xpos = atoi(icon.substr(par_beg, comma - par_beg).c_str());
    int par_end = icon.find(")", comma) - 1;
    int ypos = atoi(icon.substr(comma + 1, par_end - comma).c_str());
    WinampIcon(xpos, ypos);
  }

  else if(icon != "")
  {
    int par_beg = icon.find("(", 0) + 1;
    int comma = icon.find(",", par_beg);
    std::string file = icon.substr(0, par_beg - 1);
    int xpos = atoi(icon.substr(par_beg, comma - par_beg).c_str());
    int par_end = icon.find(")", comma) - 1;
    int ypos = atoi(icon.substr(comma + 1, par_end - comma).c_str());
    DrawIcon(xpos, ypos, file.c_str());
  }
}
//---------------------------------------------------------------------------

void cLCD::DrawIcon(int xpos, int ypos, AnsiString filename)
{  // show icon on screen

  Graphics::TBitmap *iconBitmap = new Graphics::TBitmap();
  try
    {
      iconBitmap->LoadFromFile(filename);

      if (vlcdEnable)
      {
        iconBitmap->Transparent = true;
        iconBitmap->TransparentMode = tmAuto;

        vlcdBitmap->Canvas->Draw(xpos,ypos,iconBitmap);
      }

      if(displaytype==0)
      {
      for(int y=0;y<iconBitmap->Height;y++)
        for(int x=0;x<iconBitmap->Width;x++)
        {
        if (iconBitmap->Canvas->Pixels[x][y]==0)
          LCD.SetPixel(xpos+x,ypos+y);
        }
      }
      else if(displaytype==1)
      {}
      else
      {}

      }
   catch (...)
   {
     ShowMessage("Could not load or display icon");
   }
   delete iconBitmap;
}

//---------------------------------------------------------------------------

void cLCD::WinampIcon(int xpos, int ypos)
{
  HWND hwndWinamp = FindWindow("Winamp v1.x",NULL);

  int status = SendMessage(hwndWinamp,WM_USER, 0, 104);

  if (status==1)
  {
   DrawIcon(xpos,ypos,"images\\play.bmp");
  }
  else if (status==3)
  {
    DrawIcon(xpos,ypos,"images\\pause.bmp");
  }
  else
  {
    DrawIcon(xpos,ypos,"images\\stop.bmp");
  }
}

//---------------------------------------------------------------------------

void cLCD::UpdateIcons(void)
{
  // if current screen has icon call icon function
  for (int i=0; i<maxicons; i++)
  {
    if (screen.Icon[currentscreen][i] != "")
    {
      LCD.ShowIcon(screen.Icon[currentscreen][i].c_str());
    }
  }
}

// } class LCD
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// { class KS0108

#include "font.h"
#include "font2.h"

#define DISPLAY_ON         0x3f  //0011 1111
#define DISPLAY_OFF        0x3e  //0011 1110
#define DISPLAY_STARTLINE  0xc0  //1100 0000   <<<<<
#define DISPLAY_PAGE_SET   0xb8  //1011 1000
#define DISPLAY_COLUMN_SET 0x40  //0100 0000

#define LCD_ENABLE      1   //0001  Inverted PIN !!!
#define LCD_CS1         0	 //0000  Inverted PIN !!!
#define LCD_CS2         6   //0110
#define LCD_inst        8   //1000  Inverted PIN !!!  di tai rs

cKS0108::cKS0108()
{

}

cKS0108::~cKS0108()
{

}

void cKS0108::GetSettings(void)
{
  DATA=0x378;
  CONTROL=DATA+2;
}

void cKS0108::StartLCD(void)
{
  GetSettings();
  StartLPTDriver();
  InitLCD();
  ClearLCD();
}

void cKS0108::QuitLCD(void)
{
  ClearLCD();
}

void cKS0108::StartLPTDriver(void)
{
  #if defined TDLPORTIO
        //ajurin hakemisto
        LCDInfo->DLPortIO1->DriverPath=ExtractFileDir(ParamStr(0));
        // ajurin avaus
        LCDInfo->DLPortIO1->OpenDriver();
        if (!LCDInfo->DLPortIO1->ActiveHW)
   {
      MessageDlg("Could not open the DriverLINX driver.",
                 mtError, TMsgDlgButtons() << mbOK, 0);
   }
   #endif
}

void cKS0108::Delay(void)
{

}

void cKS0108::SendLCDCommand(unsigned char value, unsigned char CS)
{
 LCDInfo->DLPortIO1->PortW[CONTROL] = CS | LCD_inst;  // cs , rs/di = 0 e=1 <<chip select, instruction write , enable yls
 Delay();
 LCDInfo->DLPortIO1->PortW[DATA] = value;  //bittikuvio datavyln
 Delay();
 LCDInfo->DLPortIO1->PortW[CONTROL] = LCD_ENABLE | CS | LCD_inst;  //cs , rs/di = 0 e=0 <<chip select, instruction write , enable alas
 Delay();
 LCDInfo->DLPortIO1->PortW[DATA] = 0;
 Delay();
}

void cKS0108::SendLCDData(const unsigned char values[], unsigned int amount)
{
 unsigned char cs;
 unsigned int counter;
 for (counter=0; counter < amount;counter++)
 {
    cs = CurrentColumn>63?LCD_CS2:LCD_CS1;   //
    LCDInfo->DLPortIO1->PortW[CONTROL] = cs;   // cs , rs/di = 1 e=1 <<chip select, data write , enable yls
    Delay();
    LCDInfo->DLPortIO1->PortW[DATA] = values[counter];  //bittikuvio datavyln
    Delay();
    LCDInfo->DLPortIO1->PortW[CONTROL] = LCD_ENABLE | cs;  // cs , rs/di = 1 e=0 <<chip select, data write , enable alas
    Delay();

    CurrentColumn++;
    if (CurrentColumn > 127)
    	return;
 }
}

void cKS0108::SetColumn(unsigned char y)
{
  //assert(y < 128);
  CurrentColumn = y;
  if (y < 64)
  {
     SendLCDCommand(DISPLAY_COLUMN_SET | (y&63), LCD_CS1);
     SendLCDCommand(DISPLAY_COLUMN_SET | 0, LCD_CS2);
  } else
  {
     SendLCDCommand(DISPLAY_COLUMN_SET | 63, LCD_CS1);
     SendLCDCommand(DISPLAY_COLUMN_SET | ((y-64)&63), LCD_CS2);
  }
}

void cKS0108::SetPage(unsigned char x)
{
  //assert( x < 8);
  SendLCDCommand(DISPLAY_PAGE_SET | x, LCD_CS1);
  SendLCDCommand(DISPLAY_PAGE_SET | x, LCD_CS2);
}

void cKS0108::SetStartLine(unsigned char line)
{
  SendLCDCommand(DISPLAY_STARTLINE | (line & 63), LCD_CS1);
  SendLCDCommand(DISPLAY_STARTLINE | (line & 63), LCD_CS2);
}

void cKS0108::ClearLCD()
{
  unsigned char value;
  int x, a;
  value = 0x0;

  //SendLCDCommand(DISPLAY_ON, LCD_CS1);
  //SendLCDCommand(DISPLAY_ON, LCD_CS2);
  SetStartLine(0);

  for (x=0;x < 8;x++)
    {
      SetPage(x);SetColumn(0);
      for (a = 0 ;a < 128; a++)
      SendLCDData(&value, 1);
    }
}

void cKS0108::InitLCD()
{
  unsigned char value;
  int x, a;
  value = 0x0;

  SendLCDCommand(DISPLAY_ON, LCD_CS1);
  SendLCDCommand(DISPLAY_ON, LCD_CS2);
  SetStartLine(0);

  for (x=0;x < 8;x++)
    {
      SetPage(x);SetColumn(0);
      for (a = 0 ;a < 128; a++)
      SendLCDData(&value, 1);
    }
}

void cKS0108::LCDprintf(unsigned char y, unsigned char page, char *Str)
{
  unsigned int n;

  SetColumn(y);
  SetPage(page);
  SetColumn(y);

  for (n = 0;n < strlen(Str);n++)
  {
    SendLCDData(&Character8x8[*(Str+n)*8], 8);
  }
}

void cKS0108::LCDprintf2(unsigned char y, unsigned char page, char *Str)
{
  unsigned int n;

  for (n = 0;n < strlen(Str);n++)
  {
    PutChr(y+n*6, page, *(Str+n));
  }
}

void cKS0108::PutChr(unsigned char y, unsigned char page, char chr)
{
  SetColumn(y);
  SetPage(page);
  //SetColumn(y);

  SendLCDData(&font5x7[((chr-32) * 5)],5);
}

void cKS0108::SetLCDXY(int x, int y)
{
SetColumn(x*8);
SetPage(y);
}

void cKS0108::SetLCDXY2(int x, int y)
{
SetColumn(x*6);
SetPage(y);
}

void cKS0108::PrintLCDText(char *string)
{
  unsigned int n;

  for (n = 0;n < strlen(string);n++)
  {
    SendLCDData(&Character8x8[*(string+n)*8], 8);
  }
}

void cKS0108::PrintLCDText2(char *string)
{
  unsigned int n;
  unsigned char value = 0x0;

  for (n = 0;n < strlen(string);n++)
  {
    if((*(string+n)-32)==0)
    {
      SetColumn(CurrentColumn+6);
    }
    else
    {
      SendLCDData(&font5x7[((*(string+n)-32) * 5)],5);
      SendLCDData(&value,1);
    }
  }
}

void cKS0108::ConvertBMP(void)
{
  byte i,j,k,bmpCol,page,bitPos,dByte = 0;
  byte oneBlock[8];

  for(page=0;page<8;page++)
  {
    for(bmpCol=0;bmpCol<16;bmpCol++)
    {
      for(i=0;i<8;i++)
              oneBlock[i] = arrayBmp[SIZEBMP -1 - i*16 - page*16*8 - bmpCol];
      for(bitPos=0;bitPos<8;bitPos++)
      {
        dByte = 0;
        for(i=0;i<8;i++)
        {    if(getbits(oneBlock[i], bitPos, 1))
          dByte += (byte)pow((double)2, (double)i);
        }
        arrayLCD[(page * 128) + 127 - (bmpCol * 8) - bitPos]= ~dByte;
      }
    }
  }
}

/* getbits:  get n bits from position p */
unsigned char cKS0108::getbits(unsigned x, int p, int n)
{
  return (x >> (p+1-n)) & ~(~0 << n);
}

void cKS0108::ShowBMP(AnsiString filename)
{
    FILE *fp;
    fp = fopen(filename.c_str(), "rb");
    fread(arrayBmp, sizeof( byte), SIZEBMP, fp);
    fclose(fp);
    ConvertBMP();

    for (int j=0;j<8;j++)
    {
      SetPage(j);
      SetColumn(0);
      for (int i=0;i<128;i++)
      {
        SendLCDData(&arrayLCD[((i+128*j) * 1)],1);
      }
    }
}

// } class KS0108
//---------------------------------------------------------------------------
