//---------------------------------------------------------------------------

#include <vcl.h>

// #define NT_VERSIO

#if defined NT_VERSIO
#include <pdh.h>
#endif

#include <vector>
#include <Inifiles.hpp>

#pragma hdrstop

#include "lcdinfo_conf_main.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TLCDInfoConf *LCDInfoConf;

#define MAXPATH 1024

#if defined NT_VERSIO

HQUERY hQuery;

typedef struct _tag_PDHCounterStruct {
    LONG lValue;	    // The current value of this counter
    HCOUNTER hCounter;      // Handle to the counter - given to use by PDH Library
} PDHCOUNTERSTRUCT, *PPDHCOUNTERSTRUCT;

std::vector<PDHCOUNTERSTRUCT*> Counters;

#endif

//---------------------------------------------------------------------------
__fastcall TLCDInfoConf::TLCDInfoConf(TComponent* Owner)
        : TForm(Owner)
{
  #if defined NT_VERSIO

  PDH_Init();

  #endif
  ReadIni();
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::AddCounter_ButtonClick(TObject *Sender)
{
  #if defined NT_VERSIO
  LPTSTR CounterPath;
  CounterPath = PDH_BrowseCounter();
  if (CounterPath != NULL)
  {
    PDH_AddCounter(CounterPath);

    TListItem  *ListItem;
    ListItem = PerformanceCounters_ListView->Items->Add();
    ListItem->Caption = "pdh_";
    ListItem->SubItems->Add(CounterPath);
    ListItem->SubItems->Add("N/A");
    ListItem->SubItems->Add("N/A");
    ListItem->SubItems->Add("N/A");

    //UpdatePerformanceCountersListValues();
  }
  #endif
}
//---------------------------------------------------------------------------

#if defined NT_VERSIO
void TLCDInfoConf::UpdatePerformanceCountersListValues()
{

  TListItem  *ListItem;

  StatusBar1->SimpleText="";
  PDH_UpdateData();
  for (unsigned int i=0; i < Counters.size(); i++)
  {
    ListItem = PerformanceCounters_ListView->Items->Item[i];
    ListItem->SubItems->Strings[1]=Counters[i]->lValue;
  }

}
#endif
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::UpdateCounterValues_ButtonClick(
      TObject *Sender)
{
  #if defined NT_VERSIO
  UpdatePerformanceCountersListValues();
  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::ReadCounterSettings_ButtonClick(TObject *Sender)
{
  #if defined NT_VERSIO
  TIniFile* perfIni = new TIniFile(IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+"LCDPERF.INI");
  TStringList *sectionsList = new TStringList;

  try
  {
    perfIni->ReadSections(sectionsList);

    for (int i = 0; i < sectionsList->Count; i++)
    {
      TListItem  *ListItem;
      ListItem = PerformanceCounters_ListView->Items->Add();
      ListItem->Caption = sectionsList->Strings[i];
      AnsiString CounterPath = perfIni->ReadString(sectionsList->Strings[i], "name", "");
      PDH_AddCounter(CounterPath.c_str());
      ListItem->SubItems->Add(CounterPath);
      ListItem->SubItems->Add("N/A");
      ListItem->SubItems->Add(perfIni->ReadFloat(sectionsList->Strings[i], "multiplier", 1));
      ListItem->SubItems->Add(perfIni->ReadInteger(sectionsList->Strings[i], "precision", NULL));
    }
  }
  __finally
  {
    delete sectionsList;
  }
  
  delete perfIni;
  //UpdatePerformanceCountersListValues();
  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::SaveCounterSettings_ButtonClick(TObject *Sender)
{
  #if defined NT_VERSIO
  DeleteFile((IncludeTrailingBackslash(ExtractFilePath(
    Application->ExeName))+"LCDPERF.INI").c_str());

  TIniFile* perfIni = new TIniFile(IncludeTrailingBackslash(
    ExtractFilePath(Application->ExeName))+"LCDPERF.INI");

  for (int i = 0; i < PerformanceCounters_ListView->Items->Count; i++)
  {
    AnsiString name = PerformanceCounters_ListView->Items->Item[i]->Caption;
    AnsiString perfname = PerformanceCounters_ListView->Items->Item[i]->SubItems->Strings[0];
    perfIni->WriteString(name,"name",perfname);

    perfIni->WriteFloat(name,"multiplier",PerformanceCounters_ListView->Items->Item[i]->SubItems->Strings[2].ToDouble());
    perfIni->WriteInteger(name,"precision",PerformanceCounters_ListView->Items->Item[i]->SubItems->Strings[3].ToInt());

  }

  delete perfIni;
  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::DeleteCounter_ButtonClick(TObject *Sender)
{
  #if defined NT_VERSIO
  if (PerformanceCounters_ListView->Selected==NULL)
  { ShowMessage("Counter not selected"); }

  else
  {
    int index = PerformanceCounters_ListView->Selected->Index;
    Counters.erase(Counters.begin()+index);
    PerformanceCounters_ListView->Selected->Delete();
  }
  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::FormatValue_ButtonClick(TObject *Sender)
{

  #if defined NT_VERSIO
  if (PerformanceCounters_ListView->Selected==NULL)
  { ShowMessage("Counter not selected"); }

  else
  {
    PerformanceCounters_ListView->Selected->SubItems->Strings[2]=Edit1->Text;
    PerformanceCounters_ListView->Selected->SubItems->Strings[3]=Edit2->Text;
  }
  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::UpdateCounterValues_CheckBoxClick(
      TObject *Sender)
{
  #if defined NT_VERSIO
  if(UpdateCounterValues_CheckBox->Checked)
    PerformanceCountersUpdate_Timer->Enabled=true;
  else if(!UpdateCounterValues_CheckBox->Checked)
    PerformanceCountersUpdate_Timer->Enabled=false;
  #endif
}


//---------------------------------------------------------------------------



void __fastcall TLCDInfoConf::Exit_ButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------


void __fastcall TLCDInfoConf::CloseForm(TObject *Sender,
      TCloseAction &Action)
{
  #if defined NT_VERSIO

  PDH_UnInit();

  #endif
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::PerformanceCountersUpdate_TimerTimer(
      TObject *Sender)
{
  #if defined NT_VERSIO
  UpdatePerformanceCountersListValues();
  #endif
}
//---------------------------------------------------------------------------


//PDH functions

#if defined NT_VERSIO

void TLCDInfoConf::PDH_Error(LPTSTR error)
{
  StatusBar1->SimpleText=StatusBar1->SimpleText + error;
}

LPTSTR TLCDInfoConf::PDH_BrowseCounter()
{
    LPTSTR pszCounterName="\\Processor(_Total)\\% Processor Time";
    PDH_BROWSE_DLG_CONFIG BrowseDlgData;
    ZeroMemory(&BrowseDlgData, sizeof(PDH_BROWSE_DLG_CONFIG));
    BrowseDlgData.bSingleCounterPerAdd = TRUE;
    BrowseDlgData.bSingleCounterPerDialog = TRUE;
    BrowseDlgData.bLocalCountersOnly = TRUE;
    BrowseDlgData.bHideDetailBox = TRUE;
    BrowseDlgData.szReturnPathBuffer  = pszCounterName;
    BrowseDlgData.cchReturnPathLength = MAXPATH;
    BrowseDlgData.dwDefaultDetailLevel = PERF_DETAIL_WIZARD;
    PDH_STATUS Status = PdhBrowseCounters(&BrowseDlgData);
    if (Status != ERROR_SUCCESS)
      return NULL;

    return pszCounterName;
}

void TLCDInfoConf::PDH_AddCounter(LPTSTR pszCounterName)
{
  PPDHCOUNTERSTRUCT pCounter;
  pCounter = new PDHCOUNTERSTRUCT;

  if (PdhAddCounter(hQuery, pszCounterName, (DWORD)pCounter, &(pCounter->hCounter)) != ERROR_SUCCESS)
  {
          delete pCounter; // clean mem
          PDH_Error("PdhAddCounter error");
          return;
  }

  Counters.insert(Counters.end(), pCounter);
}

void TLCDInfoConf::PDH_Init()
{
  if (PdhOpenQuery(NULL, 1, &hQuery) != ERROR_SUCCESS)
    PDH_Error("PdhOpenQuery error");
}

void TLCDInfoConf::PDH_UnInit()
{
  PdhCloseQuery(&hQuery);
}

void TLCDInfoConf::PDH_UpdateData()
{
  if (PdhCollectQueryData(hQuery) != ERROR_SUCCESS)
    PDH_Error("PdhCollectQueryData error");

  for(unsigned int i = 0; i < Counters.size(); i++)
  {
    PDH_FMT_COUNTERVALUE pdhFormattedValue;

    if (PdhGetFormattedCounterValue(Counters[i]->hCounter, PDH_FMT_LONG, NULL, &pdhFormattedValue) != ERROR_SUCCESS)
    {
      PDH_Error("PdhGetFormattedCounterValue error");
    }
    if (pdhFormattedValue.CStatus != ERROR_SUCCESS)
    {
      PDH_Error("pdhFormattedValue.CStatus error");
    }

    Counters[i]->lValue = pdhFormattedValue.longValue;
  }
}

#endif
//---------------------------------------------------------------------------

void TLCDInfoConf::ReadIni(void)
{

TIniFile* ini = new TIniFile(IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+"LCDINFO.INI");

  int BASE  =  ini->ReadInteger( "Port", "Base", 0x378 );
  if(BASE==0x278)
    LPT_RadioButton2->Checked=true;
  else
    LPT_RadioButton1->Checked=true;

  bool checkbusyflag = ini->ReadBool( "T6963C", "CheckBusyFlag", false);
  if(checkbusyflag)
    CheckBusyFlag_CheckBox->Checked=true;

  int wiring  =  ini->ReadInteger( "T6963C", "Wiring", 0 );
  if(wiring==1)
    Wiring_RadioButton2->Checked=true;
  else Wiring_RadioButton1->Checked=true;

  int t6963csize = ini->ReadInteger( "T6963C", "Size", 1 );
  if(t6963csize==1)
    Size_RadioButton1->Checked=true;
  else if(t6963csize==2)
    Size_RadioButton2->Checked=true;
  else if(t6963csize==3)
    Size_RadioButton3->Checked=true;
  else if(t6963csize==4)
    Size_RadioButton4->Checked=true;
  else if(t6963csize==5)
    Size_RadioButton5->Checked=true;

  int displaytype = ini->ReadInteger( "LCD", "Type", 3 );
  if(displaytype==0)
    Controller_RadioButton1->Checked=true;
  else if(displaytype==1)
    Controller_RadioButton2->Checked=true;
  else
    Controller_RadioButton3->Checked=true;

  ScreenConfig_Edit->Text = ini->ReadString( "Screens", "ScreenFile", "screens\\default.ini" );

  UpdateInterval_Edit->Text = ini->ReadInteger( "Screens", "Update", 1000);

  bool PDHEnable = ini->ReadBool( "NTPerfMon", "Enable", false);
  if(PDHEnable)
    PerfMon_CheckBox->Checked=true;

  TIniFile *screenfile;
  screenfile = new TIniFile(IncludeTrailingBackslash(
    ExtractFilePath(Application->ExeName)) + ScreenConfig_Edit->Text);

  ScreenConfig_Memo->Text = screenfile->ReadString( "Info", "Description", "LCDInfo screen config" );

  delete ini;
  delete screenfile;
}
void __fastcall TLCDInfoConf::ReadSettings_ButtonClick(TObject *Sender)
{
 ReadIni();
}
//---------------------------------------------------------------------------

void TLCDInfoConf::SaveIni(void)
{

TIniFile* ini = new TIniFile(IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+"LCDINFO.INI");

  if(LPT_RadioButton2->Checked==true)
    ini->WriteInteger("Port","Base",0x278);
  else
    ini->WriteInteger("Port","Base",0x378);

  if(CheckBusyFlag_CheckBox->Checked==true)
    ini->WriteBool( "T6963C", "CheckBusyFlag", true);
  else
    ini->WriteBool( "T6963C", "CheckBusyFlag", false);

  if(Wiring_RadioButton2->Checked==true)
    ini->WriteInteger( "T6963C", "Wiring", 1 );
  else
    ini->WriteInteger( "T6963C", "Wiring", 0 );

  if(Size_RadioButton1->Checked==true)
  {
    ini->WriteInteger( "T6963C", "Size", 1 );
    ini->WriteInteger("LCD", "TextColumns", 40);
    ini->WriteInteger("LCD", "TextRows", 8);
    ini->WriteInteger("LCD", "XPixels", 240);
    ini->WriteInteger("LCD", "YPixels", 64);
  }
  else if(Size_RadioButton2->Checked==true)
  {
    ini->WriteInteger( "T6963C", "Size", 2 );
    ini->WriteInteger("LCD", "TextColumns", 40);
    ini->WriteInteger("LCD", "TextRows", 16);
    ini->WriteInteger("LCD", "XPixels", 240);
    ini->WriteInteger("LCD", "YPixels", 128);
  }
  else if(Size_RadioButton3->Checked==true)
  {
    ini->WriteInteger( "T6963C", "Size", 3 );
    ini->WriteInteger("LCD", "TextColumns", 32);
    ini->WriteInteger("LCD", "TextRows", 5);
    ini->WriteInteger("LCD", "XPixels", 256);
    ini->WriteInteger("LCD", "YPixels", 40);
  }
  else if(Size_RadioButton4->Checked==true)
  {
    ini->WriteInteger( "T6963C", "Size", 4 );
    ini->WriteInteger("LCD", "TextColumns", 16);
    ini->WriteInteger("LCD", "TextRows", 16);
    ini->WriteInteger("LCD", "XPixels", 128);
    ini->WriteInteger("LCD", "YPixels", 128);
  }
  else if(Size_RadioButton5->Checked==true)
  {
    ini->WriteInteger( "T6963C", "Size", 5 );
    ini->WriteInteger("LCD", "TextColumns", 22);
    ini->WriteInteger("LCD", "TextRows", 16);
    ini->WriteInteger("LCD", "XPixels", 128);
    ini->WriteInteger("LCD", "YPixels", 128);
  }

  if(Controller_RadioButton1->Checked==true)
    ini->WriteInteger( "LCD", "Type", 0 );
  else if(Controller_RadioButton2->Checked==true)
  {
    ini->WriteInteger( "LCD", "Type", 1 );
    ini->WriteInteger("LCD", "TextColumns", 21);
    ini->WriteInteger("LCD", "TextRows", 8);
    ini->WriteInteger("LCD", "XPixels", 128);
    ini->WriteInteger("LCD", "YPixels", 64);
  }
  else
    ini->WriteInteger( "LCD", "Type", 3 );

  ini->WriteString( "Screens", "ScreenFile", ScreenConfig_Edit->Text);

  ini->WriteInteger( "Screens", "Update", UpdateInterval_Edit->Text.ToInt());

  if(PerfMon_CheckBox->Checked==true)
    ini->WriteBool( "NTPerfMon", "Enable", true);
  else
    ini->WriteBool( "NTPerfMon", "Enable", false);

  delete ini;
}
void __fastcall TLCDInfoConf::SaveSettings_ButtonClick(TObject *Sender)
{
 SaveIni();        
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfoConf::ScreenConfig_ButtonClick(TObject *Sender)
{
  OpenDialog1->InitialDir=IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+ "screens";
  if (OpenDialog1->Execute())
  {
    ScreenConfig_Edit->Text = "screens\\" + ExtractFileName(OpenDialog1->FileName);

    TIniFile *screenfile;
    screenfile = new TIniFile(IncludeTrailingBackslash(
    ExtractFilePath(Application->ExeName)) + ScreenConfig_Edit->Text);
    ScreenConfig_Memo->Text = screenfile->ReadString( "Info", "Description", "LCDInfo screen config" );
    delete screenfile;
  }
}
//---------------------------------------------------------------------------

