// ---------------------------------------------------------------------------
// ----------------------------------------- Copyright 2001 A@majland.org ----
// ---------------------------------------------------------------------------
//
//                MotherBoard Monitor shared Memory C++ Acesss Functions
//
//  Modules     : MBMCAF.cpp, MBMCAF.h
//
//
//  Version     : 0.3
//  Date        : 2001.11.01
//
//  Target      : Borland C++ Builder 5.00
//  OS          : Tried on WinNT4.0 and Win2000
//  MBM         : version 5.1
//
//  Author      : Anders@Majland.org
//                http://www.majland.org/sw/mbmcaf
//
//  Info        : This is a few functions to read and/or write to the
//                shared memory of MotherBoard Monitor 5 (MBM5)
//                by Alexander van Kaam. MBM5 is available from
//                http://mbm.livewiredev.com/
//
//                The functions are a translation of Alex's pascal
//                code examples wrapped into a c++ class.
//
//                You can use it in two ways. If you set UserUpdate to true you
//                have to call Update youself before using the GetXXX() functions
//                The defualt is that it will update a copy of the shared
//                memory each time a GetXXX is called.
//
//  Licence     : Cardware. (Send me a note/email if you find it usefull.)
//                Basically you may use it as you see fit as long as the origin
//                of the code remains clear
//
//  History     :
//                0.3 2001.11.01 The shared memory interface of MBM has changed with version 5.1
//		  0.2 2001.05.23 Added 3 CloseHandle (that was missing)
//		  0.1 2001.05.09 First release
// ---------------------------------------------------------------------------

#ifndef mbmcafH
#define mbmcafH

#include <values.h>

const int NrTemperature = 10;
const int NrVoltage = 10;
const int NrFan = 10;
const int NrCPU = 4;

const int StringLength = 41;
const int VersionLength = 11;

const int ERR_Int    = MaxInt;
const int ERR_Double = MAXDOUBLE;

class MBMCAF_c{
  public:

    enum Bus   {ISA, SMBus, VIA686ABus, DirectIO};
    enum SMB   {SMBIntel, SMBAMD};

//    enum Voltages {VCore0, Vcore1, V33, V5, V12, V_12,V_5, NrVoltage=10};

    struct Data_s{
      int     Temperature[NrTemperature]; // Holding the [NrTemperature] possible temps
      double  Voltage[NrVoltage];         // Holding the [NrVoltage] possible voltages
      int     Fan[NrFan];                 // Holding the 4 possible fans
      int     MHZ;                        // CPU freq
      byte    CPUs;                      // Number of CPU's
      double  CPUUsage[NrCPU];            // Holding the [NrCpu] possible "Usages"
    };

    struct Info_s{
      char    MBM_version[VersionLength];  // Version og MBM (>=5.1 supported)
      unsigned short SMB_Base;            // SMBus base address
      Bus     SMB_Type;                    // SMBus/Isa bus used to access chip
      SMB     SMB_Code;                    // SMBus sub type, Intel based or AMD
      Byte    SMB_Addr;                   // Address of sensor chip on SMBus
      char    SMB_Name[StringLength];     // Nice name for SMBus
      unsigned short ISA_Base;            // ISA base address of sensor chip on ISA
      unsigned short ChipType;            // Chip nr, connects with Chipinfo.ini
      byte    VoltageSubType;             // Subvoltage option selected
    };

    struct HighLow_s{                                  // Avarage = A / C
      long          TempC[NrTemperature]; // total number of readouds of temp
      long double   TempA[NrTemperature]; // total amount of all readouts of temp
      double        TempL[NrTemperature]; // lowest value so far of temp
      double        TempH[NrTemperature]; // highest value so far of temp

      long          VoltC[NrVoltage];     // total number of readouts of voltage
      long double   VoltA[NrVoltage];     // total amount of all readouts of voltage
      double        VoltL[NrVoltage];     // lowest value so far of voltage
      double        VoltH[NrVoltage];     // highest value so far of voltage

      long          FanC[NrFan];          // total number of readouds of fan
      long double   FanA[NrFan];          // total amount of all readouts of fan
      double        FanL[NrFan];          // lowest value so far of fan
      double        FanH[NrFan];          // highest value so far of fan

      char          Start[StringLength];  // starting time
      char          Current[StringLength];// current time

      long          CPUC[NrCPU];          // total number of readouds of CPU usage
      long double   CPUA[NrCPU];          // total amount of all readouts of CPU usage
      double        CPUL[NrCPU];          // lowest value so far of CPU usage
      double        CPUH[NrCPU];          // highest value so far of CPU usage
    };

    MBMCAF_c::MBMCAF_c();
    MBMCAF_c::~MBMCAF_c();

    void __fastcall MBMCAF_c::SetUserUpdate(bool update){UserUpdate = update;}
    bool __fastcall MBMCAF_c::GetUserUpdate(void) {return UserUpdate;}
    bool __fastcall MBMCAF_c::Update(void);
    bool __fastcall MBMCAF_c::SetTemp(unsigned char sensor,int value);
    bool __fastcall MBMCAF_c::SetFan(unsigned char fan,int value);
    bool __fastcall MBMCAF_c::SetVoltage(unsigned char voltage,double value);

    int __fastcall MBMCAF_c::GetTemp(unsigned char sensor);
    int __fastcall MBMCAF_c::GetFan(unsigned char fan);
    double __fastcall MBMCAF_c::GetVoltage(unsigned char voltage);

    MBMCAF_c::Data_s* __fastcall MBMCAF_c::GetData(void);
    MBMCAF_c::Info_s * __fastcall MBMCAF_c::GetInfo(void);
    MBMCAF_c::HighLow_s * __fastcall MBMCAF_c::GetHighLow(void);

  protected:

    bool UserUpdate;

    struct Shared{
      Data_s    Data;
      Info_s    Info;
      HighLow_s HighLow;
    }Copy;

    bool __fastcall MBMCAF_c::ReadSharedData(void);
    bool __fastcall MBMCAF_c::ReadSharedInfo(void);
    bool __fastcall MBMCAF_c::ReadSharedHL(void);

};
//---------------------------------------------------------------------------
#endif
