// ---------------------------------------------------------------------------
// ----------------------------------------- Copyright 2001 A@majland.org ----
// ---------------------------------------------------------------------------

#include <vcl.h>
#include "mbmcaf.h"
#pragma package(smart_init)
// ---------------------------------------------------------------------------
// Init
// ---------------------------------------------------------------------------
MBMCAF_c::MBMCAF_c()
{
  UserUpdate = false;
}
MBMCAF_c::~MBMCAF_c()
{
}

// ---------------------------------------------------------------------------
//  Update
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::Update(void){
  if (ReadSharedData() && ReadSharedInfo() && ReadSharedHL())
    return true;
  else
    return false;

}
// ---------------------------------------------------------------------------
//  ReadSharedData
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::ReadSharedData(void)
{

  Data_s *ptr;
  HANDLE hSData;

  hSData=OpenFileMapping(FILE_MAP_READ, False, "$M$B$M$5$D$");
  if (hSData==0) return false;

  ptr = (Data_s *)MapViewOfFile(hSData, FILE_MAP_READ, 0, 0, 0);
  if (ptr == 0){
      CloseHandle(hSData);
      return false;
  }

  for (int i=0;i<NrTemperature;i++){
    Copy.Data.Temperature[i] = ptr->Temperature[i];
  }
  for (int i=0;i<NrVoltage;i++){
    Copy.Data.Voltage[i] = ptr->Voltage[i];
  }
  for (int i=0;i<NrFan;i++){
    Copy.Data.Fan[i] = ptr->Fan[i];
  }
  Copy.Data.MHZ = ptr->MHZ;
  Copy.Data.CPUs =ptr->CPUs;

  UnmapViewOfFile(ptr);
  CloseHandle(hSData);

  return true;
}
// ---------------------------------------------------------------------------
//  ReadSharedInfo
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::ReadSharedInfo(void)
{
  Info_s *ptr;
  HANDLE       hSInfo;

  hSInfo = OpenFileMapping(FILE_MAP_READ, False, "$M$B$M$5$I$");
  if (hSInfo==0){return false;}
  ptr=(Info_s *)MapViewOfFile(hSInfo, FILE_MAP_READ, 0, 0, 0);
  if (ptr==0){
    CloseHandle(hSInfo);
    return false;
  }

  Copy.Info.SMB_Base       = ptr->SMB_Base;
  Copy.Info.SMB_Type       = ptr->SMB_Type;
  Copy.Info.SMB_Code       = ptr->SMB_Code;
  Copy.Info.SMB_Addr       = ptr->SMB_Addr;
  strncpy(Copy.Info.SMB_Name,ptr->SMB_Name,StringLength);
  Copy.Info.ISA_Base        = ptr->ISA_Base;
  Copy.Info.ChipType       = ptr->ChipType;
  Copy.Info.VoltageSubType = ptr->VoltageSubType;


  UnmapViewOfFile(ptr);
  CloseHandle(hSInfo);
  return true;
}
// ---------------------------------------------------------------------------
//  ReadSharedHL
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::ReadSharedHL(void)
{
  HighLow_s   *ptr;
  HANDLE       hSHL;

  hSHL = OpenFileMapping(FILE_MAP_READ, False, "$M$B$M$5$H$");
  if (hSHL==0){return false;}
  ptr=(HighLow_s *)MapViewOfFile(hSHL, FILE_MAP_READ, 0, 0, 0);
  if (ptr==0){
    CloseHandle(hSHL);
    return false;
  }
  for (int i=0;i<NrTemperature;i++){
    Copy.HighLow.TempC[i] = ptr->TempC[i];
    Copy.HighLow.TempA[i] = ptr->TempA[i];
    Copy.HighLow.TempL[i] = ptr->TempL[i];
    Copy.HighLow.TempH[i] = ptr->TempH[i];
  }
  for (int i=0;i<NrVoltage;i++){
    Copy.HighLow.VoltC[i] = ptr->VoltC[i];
    Copy.HighLow.VoltA[i] = ptr->VoltA[i];
    Copy.HighLow.VoltL[i] = ptr->VoltL[i];
    Copy.HighLow.VoltH[i] = ptr->VoltH[i];
  }
  for (int i=0;i<NrFan;i++){
    Copy.HighLow.FanC[i] = ptr->FanC[i];
    Copy.HighLow.FanA[i] = ptr->FanA[i];
    Copy.HighLow.FanL[i] = ptr->FanL[i];
    Copy.HighLow.FanH[i] = ptr->FanH[i];
  }
  strncpy(Copy.HighLow.Start,ptr->Start,StringLength);
  strncpy(Copy.HighLow.Current,ptr->Current,StringLength);


  UnmapViewOfFile(ptr);
  CloseHandle(hSHL);
  return true;
}
// ---------------------------------------------------------------------------
// SetTemp
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::SetTemp(unsigned char sensor,int value)
{
  if(sensor>=NrTemperature)return false;

  HANDLE hSData;
  Data_s *ptr;

  hSData=OpenFileMapping(FILE_MAP_WRITE, False, "$M$B$M$5$D$");
  if (hSData==0) return false;
  ptr = (Data_s *)MapViewOfFile(hSData, FILE_MAP_WRITE, 0, 0, 0);
  if (ptr == 0){
      CloseHandle(hSData);
      return false;
  }

  ptr->Temperature[sensor] = value;

  CloseHandle(hSData);
  UnmapViewOfFile(ptr);

  return true;
}
// ---------------------------------------------------------------------------
//  SetFan
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::SetFan(unsigned char sensor,int value)
{
  if(sensor>=NrFan)return false;

  HANDLE hSData;
  Data_s *ptr;

  hSData=OpenFileMapping(FILE_MAP_WRITE, False, "$M$B$M$5$D$");
  if (hSData==0) return false;
  ptr = (Data_s *)MapViewOfFile(hSData, FILE_MAP_WRITE, 0, 0, 0);
  if (ptr == 0){
      CloseHandle(hSData);
      return false;
  }

  ptr->Fan[sensor] = value;

  CloseHandle(hSData);
  UnmapViewOfFile(ptr);
  return true;
}
// ---------------------------------------------------------------------------
// SetVoltage
// ---------------------------------------------------------------------------
bool __fastcall MBMCAF_c::SetVoltage(unsigned char sensor,double value)
{
  if(sensor>=NrVoltage)return false;

  HANDLE hSData;
  Data_s *ptr;

  hSData=OpenFileMapping(FILE_MAP_WRITE, False, "$M$B$M$5$D$");
  if (hSData==0) return false;
  ptr = (Data_s *)MapViewOfFile(hSData, FILE_MAP_WRITE, 0, 0, 0);
  if (ptr == 0){
      CloseHandle(hSData);
      return false;
  }

  ptr->Voltage[sensor] = value;
  ptr->CPUs = 2; //?\\

  CloseHandle(hSData);
  UnmapViewOfFile(ptr);
  return true;
}
// ---------------------------------------------------------------------------
// GetData (struct)
// ---------------------------------------------------------------------------
MBMCAF_c::Data_s * __fastcall MBMCAF_c::GetData(void)
{
  if(!UserUpdate)
    ReadSharedData();
  return &Copy.Data;
}
// ---------------------------------------------------------------------------
// GetInfo (struct)
// ---------------------------------------------------------------------------
MBMCAF_c::Info_s * __fastcall  MBMCAF_c::GetInfo(void)
{
  if(!UserUpdate)
    ReadSharedInfo();
  return &Copy.Info;
}
// ---------------------------------------------------------------------------
// GetHighLow (struct)
// ---------------------------------------------------------------------------
MBMCAF_c::HighLow_s * __fastcall MBMCAF_c::GetHighLow(void)
{
  if(!UserUpdate)
    ReadSharedHL();
  return &Copy.HighLow;
}
// ---------------------------------------------------------------------------
// GetTemp (data.temp[])
// ---------------------------------------------------------------------------
int __fastcall MBMCAF_c::GetTemp(unsigned char sensor)
{

  if(sensor>=NrTemperature)
    return ERR_Int;

  if(!UserUpdate)
    ReadSharedData();

    return Copy.Data.Temperature[sensor];
}
// ---------------------------------------------------------------------------
// GetFan (data.fan[])
// ---------------------------------------------------------------------------
int __fastcall MBMCAF_c::GetFan(unsigned char fan)
{
  if(fan>=NrFan)
    return ERR_Int;
  if(!UserUpdate)
    ReadSharedData();
  return Copy.Data.Fan[fan];
}
// ---------------------------------------------------------------------------
// GetFemp (data.Voltage)
// ---------------------------------------------------------------------------
double __fastcall MBMCAF_c::GetVoltage(unsigned char voltage)
{
  if(voltage>=NrVoltage)
    return ERR_Double;
  if(!UserUpdate)
    ReadSharedData();
  return Copy.Data.Voltage[voltage];
}
