//---------------------------------------------------------------------------

#include <vcl.h> 
#include <stdio.h>
#include <IniFiles.hpp>

#include <iostream>
#include <string>
#include <sstream>
#include <iomanip>

#pragma hdrstop

#include "OLCD.h"
#include "mbmcaf.cpp"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TDLPortIO"
#pragma resource "*.dfm"

#define G_BASE 0x0200   // grafiikkamuistin base address
#define T_BASE 0x0000   // tekstimuistin base address
#define BYTES_PER_ROW 40 // merkki rivill

// nykyn luetaan LCDINFO.INI tiedostosta
//#define BASE 0x378      // lpt portin osoite

#define XMAX 239
#define XMIN 0
#define YMAX 63
#define YMIN 0

int currentscreen=0;
int mailcount=0;
int BASE;

AnsiString Pop3Host;
AnsiString Pop3UserID;
AnsiString Pop3Password;
bool Pop3Enable;

struct Screen{
bool Enable[5];
int Interval[5];
AnsiString Bitmap[5];
AnsiString Lines[5][8];
}screen;

std::string lcdbuffer[8];

TLCDInfo *LCDInfo;
//---------------------------------------------------------------------------
__fastcall TLCDInfo::TLCDInfo(TComponent* Owner)
        : TForm(Owner)
{

TIniFile *ini;
ini = new TIniFile(IncludeTrailingBackslash(
  ExtractFilePath(Application->ExeName))+"LCDINFO.INI");

BASE  =  ini->ReadInteger( "Port", "Base", 0x378 );
UpdateTimer1->Interval = ini->ReadInteger( "Screens", "Update", 1000);
Pop3Host = ini->ReadString( "Pop3", "Host", "");
Pop3UserID = ini->ReadString( "Pop3", "UserID", "");
Pop3Password = ini->ReadString( "Pop3", "Password", "");
Pop3Enable = ini->ReadBool( "Pop3", "Enable", false);

for (int i=0;i<5;i++)
  screen.Enable[i]=ini->ReadBool( "Screen"+IntToStr(i),"Enable", false);
Memo1->Lines->Add("Enabled:");
for (int i=0;i<5;i++)
  Memo1->Lines->Add(IntToStr(screen.Enable[i]));

for (int i=0;i<5;i++)
  screen.Interval[i]=ini->ReadInteger( "Screen"+IntToStr(i),"Interval", 5000);
Memo1->Lines->Add("Interval:");
for (int i=0;i<5;i++)
  Memo1->Lines->Add(IntToStr(screen.Interval[i]));

for (int i=0;i<5;i++)
  screen.Bitmap[i]=ini->ReadString( "Screen"+IntToStr(i),"Bitmap", "");
Memo1->Lines->Add("Bitmap:");
for (int i=0;i<5;i++)
  Memo1->Lines->Add(screen.Bitmap[i]);

for (int i=0;i<5;i++)
{
  for (int j=0;j<8;j++)
  {
    screen.Lines[i][j]=ini->ReadString( "Screen"+IntToStr(i),"Line"+IntToStr(j), "ee");
  }
}

Memo1->Lines->Add("Lines:");
for (int i=0;i<5;i++)
  {
    Memo1->Lines->Add("==========");
    for (int j=0;j<8;j++)
      Memo1->Lines->Add(screen.Lines[i][j]);
  }

delete ini;

StartLPTDriver();
InitLCD();
ClearLCDText();
ClearLCDGraph();

if (screen.Bitmap[currentscreen] != "")
{
  LCDInfo->Piirra_BMP(screen.Bitmap[currentscreen]);
}

}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Lopeta_Button1Click(TObject *Sender)
{
ClearLCDText();
ClearLCDGraph();
Close();
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Mode_CheckBox1Click(TObject *Sender)
{
BYTE b=0x90;
  if (Mode_CheckBox1->Checked) b = b | 1;
  if (Mode_CheckBox2->Checked) b = b | 2;
  if (Mode_CheckBox3->Checked) b = b | 8;
  if (Mode_CheckBox4->Checked) b = b | 4;
  WriteCtrl(b);

}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Mode_CheckBox2Click(TObject *Sender)
{
Mode_CheckBox1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Mode_CheckBox3Click(TObject *Sender)
{
Mode_CheckBox1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::Mode_CheckBox4Click(TObject *Sender)
{
Mode_CheckBox1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::UpdateTimer1Timer(TObject *Sender)
{
  LCDInfo->ClearLCDText();

  for (int i=0;i<8;i++)
  {
    lcdbuffer[i]=LCDInfo->IniLineToLCDLine(screen.Lines[currentscreen][i].c_str());
  }

  Memo2->Clear();
  for (int i=0;i<8;i++)
  {
    LCDInfo->SetLCDXY(0,i);
    AnsiString lcdline = lcdbuffer[i].c_str();
    LCDInfo->PrintLCDText(lcdline.c_str());
    Memo2->Lines->Add(lcdbuffer[i].c_str());
  }

}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::changescreen_Timer1Timer(TObject *Sender)
{
  do{
    if (currentscreen<4)
      currentscreen++;
    else currentscreen=0;
  }while (screen.Enable[currentscreen]==false);

  LCDInfo->ClearLCDGraph();
  if (screen.Bitmap[currentscreen] != "")
  {
    LCDInfo->Piirra_BMP(screen.Bitmap[currentscreen]);
  }
}
//---------------------------------------------------------------------------

void __fastcall TLCDInfo::POP3_Timer1Timer(TObject *Sender)
{
  if (Pop3Enable)
  {
    if (NMPOP31->Connected)
        NMPOP31->Disconnect();
     else
       {

        NMPOP31->Host = Pop3Host;
        NMPOP31->UserID = Pop3UserID;
        NMPOP31->Password = Pop3Password;
        NMPOP31->Connect();
        mailcount=NMPOP31->MailCount;
      }
  }
}
//---------------------------------------------------------------------------

std::string __fastcall TLCDInfo::VarToValue(std::string var)
{
 std::stringstream value;

 MBMCAF_c test;
 int temp0, temp1, temp2, fan0, fan1, fan2;
 double voltage0, voltage1, voltage2, voltage3, voltage4, voltage5, voltage6;
 MBMCAF_c::Data_s* data = test.GetData();

 long secs,s,d,h,h2,m,rs;
 secs = GetTickCount();
 s = secs/1000;
 h = s / 3600;
 m = (s - (h * 3600))/60;
 rs= (s - ((m * 60) + (h * 3600)));
 d = (s / 3600) / 24;
 h2 = s / 3600 -(d*24);

 MEMORYSTATUS MemStatus;
 MemStatus.dwLength = sizeof(MemStatus);
 GlobalMemoryStatus(&MemStatus);

 HWND hwndWinamp = FindWindow("Winamp v1.x",NULL);
 
  //MBM
 if (var=="mbmtemp0")
   value << test.GetTemp(0);
 else if (var=="mbmtemp1")
   value << test.GetTemp(1);
 else if (var=="mbmtemp2")
   value << test.GetTemp(2);

 else if (var=="mbmvolt0")
   value << std::setprecision(3) << test.GetVoltage(0);
 else if (var=="mbmvolt1")
   value << std::setprecision(3) << test.GetVoltage(1);
 else if (var=="mbmvolt2")
   value << std::setprecision(3) << test.GetVoltage(2);
 else if (var=="mbmvolt3")
   value << std::setprecision(3) << test.GetVoltage(3);
 else if (var=="mbmvolt4")
   value << std::setprecision(3) << test.GetVoltage(4);
 else if (var=="mbmvolt5")
   value << std::setprecision(3) << test.GetVoltage(5);
 else if (var=="mbmvolt6")
   value << std::setprecision(3) << test.GetVoltage(6);

 else if (var=="mbmfan0")
   value << test.GetFan(0);
 else if (var=="mbmfan1")
   value << test.GetFan(1);
 else if (var=="mbmfan0")
   value << test.GetFan(1);

 else if (var=="mbmmhz")
   value << data->MHZ;

 // uptime
 else if (var=="uptimed")
   value << d;
 else if (var=="uptimeh")
   value << h2;
 else if (var=="uptimem")
   value << m;
 else if (var=="uptimes")
   value << rs;

 // memstatus
 else if (var=="memtotphys")
   value << MemStatus.dwTotalPhys/1024;
 else if (var=="memavphys")
   value << MemStatus.dwAvailPhys/1024;
 else if (var=="memusage")
   value << MemStatus.dwMemoryLoad;
 else if (var=="memtotpage")
   value << MemStatus.dwTotalPageFile/1024;
 else if (var=="memavpage")
   value << MemStatus.dwAvailPageFile/1024;
 else if (var=="memtotvirt")
   value << MemStatus.dwTotalVirtual/1024;
 else if (var=="memavvirt")
   value << MemStatus.dwAvailVirtual/1024;

 // computername
 else if (var=="computername")
 {
   char compuname[50];
   unsigned long nSize=sizeof(compuname);

   GetComputerName(compuname,&nSize);
   value << compuname;
 }

 // pop3 mail
 else if (var=="mailcount")
   value << mailcount;

 // winamp
 else if (var=="winampstatus")
   {
     int status = SendMessage(hwndWinamp,WM_USER, 0, 104);

     if (status==1)
        value << "playing";
     else if (status==3)
        value << "paused";
     else
        value << "stopped";
   }
 else if (var=="winamptrackpos")
   {
   int pos=SendMessage(hwndWinamp,WM_USER, 0, 105);
   value << pos/1000/60 << ":" << std::setprecision(2) << pos/1000%60;
   }
 else if (var=="winamptracklen")
   {
   int pos=SendMessage(hwndWinamp,WM_USER, 1, 105);
   value << pos/60 << ":" << pos%60;
   }
 //sprintf(string,"%d:%.2d / %d:%.2d",ret2/1000/60, ret2/1000%60, ret3/60, ret3%60);
 else if (var=="winamptitle")
   {
   char this_title[2048],*p;
   GetWindowText(hwndWinamp,this_title,sizeof(this_title));
   p = this_title+strlen(this_title)-8;
   while (p >= this_title)
   {
     if (!strnicmp(p,"- Winamp",8)) break;
     p--;
   }
   if (p >= this_title) p--;
   while (p >= this_title && *p == ' ') p--;
   *++p=0;

   value << this_title;
   }

 return value.str();
}
//---------------------------------------------------------------------------

std::string __fastcall TLCDInfo::IniLineToLCDLine(std::string str2)
{
  std::string str = str2;

  int len = str.length();

  for(int i = 0; i < len; i++)
  {
        if(str[i] == '$')
        {
              int kw_beg = i + 1;
              int kw_end = str.find("$", kw_beg);
              int kw_len = kw_end - kw_beg;

              if(kw_len < 0)
                      continue;

              std::string keyword = str.substr(kw_beg, kw_len);
              std::stringstream stor;

              stor.clear();

              /*if(keyword == "mhzmuuttuja")
                      stor << 1400;
              else if(keyword == "mbmtemp")
                      stor << 53;
              else if(keyword == "lehma")
                      stor << "Mansikki";
              */
              stor << VarToValue(keyword);

              str.replace(kw_beg - 1, kw_len + 2, stor.str());

              i += stor.str().length() - 1;
              len = str.length();
        }
  }
  return str;
}
//---------------------------------------------------------------

void __fastcall TLCDInfo::Piirra_BMP(AnsiString filename)
{
  int x=0,y=0,z=0;
  int i=0;
  float pp=0;
  TColor p;
  int addr=0;

  Randomize();

  Graphics::TBitmap *pBitmap = new Graphics::TBitmap();
  try
  {
  
    pBitmap->LoadFromFile(filename);
    Canvas->Draw(15,350,pBitmap);

    /*for(y=0;y<64;y++)
      for(x=0;x<240;x++)
        {
        if (pBitmap->Canvas->Pixels[x][y]==0)
          Form1->SetLCDPixel(x,y);
        }*/

  addr = G_BASE + (y*BYTES_PER_ROW) + (x/6);
  //WriteCtrl(0xf8 | (5-(x % 6)));   // ???

  WriteData(addr & 0xFF);
  WriteData(addr >> 8);
  WriteCtrl(0x24);
  for (y=0;y<64;y++)
    for (x=0;x<240/6;x++)
    {
      i=0;
      for(z=0;z<6;z++)
      {
        p=pBitmap->Canvas->Pixels[x*6+z][y];
        pp=0.6*(p & 0xFF)+0.30*((p >> 8) & 0xFF)+0.1*((p >> 16) & 0xFF);
        i=i << 1;
        if (pp<=random(255))
           i=i | 1;
      }
      WriteData(i);
      WriteCtrl(0xC0);
    }
  }


  
  catch (...)

  {
    ShowMessage("Could not load or display bitmap");
  }
  delete pBitmap;
}

/* OMAT LCD FUNKTIOT *******************************************/
/***************************************************************/

void __fastcall TLCDInfo::StartLPTDriver(void)
{
        //ajurin hakemisto
        DLPortIO1->DriverPath=ExtractFileDir(ParamStr(0));
        // ajurin avaus
        DLPortIO1->OpenDriver();
        if (!DLPortIO1->ActiveHW)
   {
      MessageDlg("Could not open the DriverLINX driver.",
                 mtError, TMsgDlgButtons() << mbOK, 0);
   }
}

void __fastcall TLCDInfo::WaitDisplayReady(void)
// lukee nytn status byten ja varmistaa,
// ett nytt on valmiina ennen kirjoitusta

// ei sisll viel mitn tarkistusta sen varalta,
// ett status byten luku ei onnistu, joten
// ohjelma on melko helppo saada jumiin

// Tss kun on vhn aikaa tt kytetty, niin
// eip tm olekaan mennyt jumiin kuin silloin
// jos koneessa ei ole LCD nytt ollenkaan kiinni.
// Jokin tarkistus pitisi kuitenkin tehd.

{
  int Tmp;

       Tmp = DLPortIO1->Port[BASE + 0x402];
       Tmp = Tmp & 0x1F;
       Tmp = Tmp | 0x20;
       DLPortIO1->Port[BASE + 0x402] = Tmp;

       do{

             DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2;     //In, CD=1, CS=0, Wr=1
             DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2 + 8; //In, CD=1, CS=0, Wr=1, Rd=0
             Tmp = DLPortIO1->Port[BASE];
             DLPortIO1->Port[BASE + 2] = 0x20 + 4 + 2;     //In, CD=1, CS=0, Wr=1

       }while ((Tmp & 3) != 3 );
       DLPortIO1->Port[BASE + 2] = 0;
}

void __fastcall TLCDInfo::WriteData(BYTE Data)
{
  //poistettu, koska muuttujien kasvaessa ohjelma hidastuu
  //WriteData_Edit1->Text=WriteData_Edit1->Text+Data+" ";
  WaitDisplayReady();
  DLPortIO1->Port[BASE] = Data;
  DLPortIO1->Port[BASE + 2] = 0; // C/D = L (Data)
  DLPortIO1->Port[BASE + 2] = 2; // CE
  DLPortIO1->Port[BASE + 2] = 3; // CE+WR
  DLPortIO1->Port[BASE + 2] = 2; // CE
  DLPortIO1->Port[BASE + 2] = 0;

}

void __fastcall TLCDInfo::WriteCtrl(BYTE Command)
{
  //poistettu, koska muuttujien kasvaessa ohjelma hidastuu
  //WriteCtrl_Edit1->Text=WriteCtrl_Edit1->Text+Command+" ";
  WaitDisplayReady();
  DLPortIO1->Port[BASE] = Command;
  DLPortIO1->Port[BASE + 2] = 4;   // C/D = H (ctrl)
  DLPortIO1->Port[BASE + 2] = 4+2; // CE
  DLPortIO1->Port[BASE + 2] = 4+3; // CE+WR
  DLPortIO1->Port[BASE + 2] = 4+2; // CE
  DLPortIO1->Port[BASE + 2] = 0;
}

void __fastcall TLCDInfo::InitLCD(void)
{
  // Display init
  WriteData(T_BASE & 0xFF);   //Data1: LowAddress
  WriteData(T_BASE >> 8);     //Data2: HighAddress
  WriteCtrl(0x40);            //Command: 0x40 -> 01000000

  WriteData(BYTES_PER_ROW);  //Data1: Colums
  WriteData(0);              //Data2: 0
  WriteCtrl(0x41);           //Command: 0x41 -> 01000001

  WriteData(G_BASE & 0xFF);  //Data1: LowAddress
  WriteData(G_BASE >> 8);    //Data2: HighAddress
  WriteCtrl(0x42);           //Command: 0x42 -> 01000010

  WriteData(BYTES_PER_ROW);  //Data1: Colums
  WriteData(0);              //Data2: 0
  WriteCtrl(0x43);           //Command: 0x43 -> 01000011

  //Internal CGROM Mode, OR Mode
  WriteCtrl(0x80); // OR Mode    //80->10000000

  WriteCtrl(0xa7); // cursor is 8 lines high
  WriteData(0x00);
  WriteData(0x00);
  WriteCtrl(0x21); // put cursor at (x,y)

  //DisplayMode
  WriteCtrl(0x9D);

  // CG RAM
  // WriteData(2);
  // WriteData(0);
  // WriteCtrl(0x22);

}

void __fastcall TLCDInfo::SetLCDXY(int x, int y)
{
int addr;
  addr = T_BASE + (y * BYTES_PER_ROW) + x;
  WriteData(addr & 0xFF);
  WriteData(addr >> 8);
  WriteCtrl(0x24);
}

void __fastcall TLCDInfo::SetLCDCursor(int x, int y)
{
  WriteData(x);
  WriteData(y);
  WriteCtrl(0x21);
}

void __fastcall TLCDInfo::ClearLCDText(void)
{
  int i;

  WriteData(T_BASE & 0xFF);
  WriteData(T_BASE >> 8);
  WriteCtrl(0x24);      // address pointer T_BASE alkuun

  for (i=0;i<320;i++) {
        WriteData(0); WriteCtrl(0xc0); // kirjoita data ja inc ptr
  }
}

void __fastcall TLCDInfo::ClearLCDGraph(void)
{
  int i;

  WriteData(G_BASE & 0xFF);
  WriteData(G_BASE >> 8);
  WriteCtrl(0x24); // address pointer G_BASE alkuun

  for (i=0;i<2560;i++){
        WriteData(0); WriteCtrl(0xc0); // kirjoita data ja inc ptr
  }
}

void __fastcall TLCDInfo::PrintLCDText(char *string)
{
  unsigned int i;
  int c;

  for (i=0;i<strlen(string);i++){
        c = string[i] - 0x20; // muunnos ASCIIsta LCD:n merkkeihin
        if (c<0) c=0;
        WriteData(c);
        WriteCtrl(0xc0);
  }
}

void __fastcall TLCDInfo::SetLCDPixel(int x, int y)
{
  int addr;

  addr = G_BASE + (y*BYTES_PER_ROW) + (x/6);
  WriteData(addr & 0xFF);
  WriteData(addr >> 8);
  WriteCtrl(0x24);
  WriteCtrl(0xf8 | (5-(x % 6)));
}


